/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RestoreSnapshotFromClientTestBase;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Assert;
import org.junit.Test;

public class RestoreSnapshotFromClientSchemaChangeTestBase
extends RestoreSnapshotFromClientTestBase {
    private Set<String> getFamiliesFromFS(TableName tableName) throws IOException {
        MasterFileSystem mfs = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        HashSet<String> families = new HashSet<String>();
        Path tableDir = CommonFSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tableName);
        for (Path regionDir : FSUtils.getRegionDirs((FileSystem)mfs.getFileSystem(), (Path)tableDir)) {
            for (Path familyDir : FSUtils.getFamilyDirs((FileSystem)mfs.getFileSystem(), (Path)regionDir)) {
                families.add(familyDir.getName());
            }
        }
        return families;
    }

    protected ColumnFamilyDescriptor getTestRestoreSchemaChangeHCD() {
        return ColumnFamilyDescriptorBuilder.of((byte[])this.TEST_FAMILY2);
    }

    @Test
    public void testRestoreSchemaChange() throws Exception {
        Table table = TEST_UTIL.getConnection().getTable(this.tableName);
        this.admin.disableTable(this.tableName);
        this.admin.addColumnFamily(this.tableName, this.getTestRestoreSchemaChangeHCD());
        this.admin.enableTable(this.tableName);
        Assert.assertEquals((long)2L, (long)table.getDescriptor().getColumnFamilyCount());
        TableDescriptor htd = this.admin.getDescriptor(this.tableName);
        Assert.assertEquals((long)2L, (long)htd.getColumnFamilyCount());
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 500, (byte[][])new byte[][]{this.TEST_FAMILY2});
        long snapshot2Rows = (long)this.snapshot1Rows + 500L;
        Assert.assertEquals((long)snapshot2Rows, (long)this.countRows(table, new byte[0][]));
        Assert.assertEquals((long)500L, (long)this.countRows(table, new byte[][]{this.TEST_FAMILY2}));
        Set<String> fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)2L, (long)fsFamilies.size());
        this.admin.disableTable(this.tableName);
        this.admin.snapshot(this.snapshotName2, this.tableName);
        this.admin.restoreSnapshot(this.snapshotName0);
        this.admin.enableTable(this.tableName);
        Assert.assertEquals((long)1L, (long)table.getDescriptor().getColumnFamilyCount());
        try {
            this.countRows(table, new byte[][]{this.TEST_FAMILY2});
            Assert.fail((String)("family '" + Bytes.toString((byte[])this.TEST_FAMILY2) + "' should not exists"));
        }
        catch (NoSuchColumnFamilyException noSuchColumnFamilyException) {
            // empty catch block
        }
        Assert.assertEquals((long)this.snapshot0Rows, (long)this.countRows(table, new byte[0][]));
        htd = this.admin.getDescriptor(this.tableName);
        Assert.assertEquals((long)1L, (long)htd.getColumnFamilyCount());
        fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)1L, (long)fsFamilies.size());
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(this.snapshotName2);
        this.admin.enableTable(this.tableName);
        htd = this.admin.getDescriptor(this.tableName);
        Assert.assertEquals((long)2L, (long)htd.getColumnFamilyCount());
        Assert.assertEquals((long)2L, (long)table.getDescriptor().getColumnFamilyCount());
        Assert.assertEquals((long)500L, (long)this.countRows(table, new byte[][]{this.TEST_FAMILY2}));
        Assert.assertEquals((long)snapshot2Rows, (long)this.countRows(table, new byte[0][]));
        fsFamilies = this.getFamiliesFromFS(this.tableName);
        Assert.assertEquals((long)2L, (long)fsFamilies.size());
        table.close();
    }
}

