/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree.avl;

import java.util.Iterator;
import java.util.Stack;
import org.apache.directory.server.core.avltree.avl.AvlNode;
import org.apache.directory.server.core.avltree.avl.AvlTreeIterator;

public class AvlTreeSet<T extends Comparable<T>>
implements Iterable<T> {
    private AvlNode<T> tree;
    private int size = 0;
    private final boolean useFreeList;
    private Stack<AvlNode<T>> freeList = new Stack();

    public AvlTreeSet() {
        this(false);
    }

    public AvlTreeSet(boolean useFreeList) {
        this.useFreeList = useFreeList;
    }

    public final int height() {
        return this.tree == null ? 0 : this.tree.height + 1;
    }

    public final int size() {
        return this.size;
    }

    @Override
    public final Iterator<T> iterator() {
        return new AvlTreeIterator<T>(this.tree);
    }

    public final boolean insert(T value) {
        if (this.tree == null) {
            this.tree = this.newNode(null, value);
            ++this.size;
            return true;
        }
        AvlNode<T> node = this.tree;
        int cmp = value.compareTo(node.value);
        while (cmp != 0) {
            if (cmp < 0) {
                if (node.left == null) {
                    node.left = this.newNode(node, value);
                    break;
                }
                node = node.left;
            } else if (cmp > 0) {
                if (node.right == null) {
                    node.right = this.newNode(node, value);
                    break;
                }
                node = node.right;
            } else assert (false) : "should never happen";
            cmp = value.compareTo(node.value);
        }
        if (cmp == 0) {
            return false;
        }
        this.rebalanceUp(node);
        ++this.size;
        return true;
    }

    private final AvlNode<T> newNode(AvlNode<T> parent, T value) {
        if (!this.useFreeList || this.freeList.isEmpty()) {
            return new AvlNode<T>(parent, value);
        }
        AvlNode<T> node = this.freeList.pop();
        return node.reset(parent, value);
    }

    private final void recycleNode(AvlNode<T> node) {
        if (!this.useFreeList) {
            return;
        }
        while (this.freeList.size() > this.size) {
            this.freeList.pop();
        }
        if (this.freeList.size() == this.size) {
            return;
        }
        this.freeList.push(node);
    }

    private void rebalanceUp(AvlNode<T> node) {
        while (node != null) {
            int heightBefore = node.height;
            AvlTreeSet.updateHeight(node);
            if (node.balance == -2) {
                node = AvlTreeSet.bigRightRotation(node);
            } else if (node.balance == 2) {
                node = AvlTreeSet.bigLeftRotation(node);
            }
            if (node.parent == null) {
                this.tree = node;
            }
            if (heightBefore == node.height) break;
            node = node.parent;
        }
    }

    public final boolean remove(T value) {
        AvlNode<T> node = this.tree;
        if (node == null) {
            return false;
        }
        int cmp = value.compareTo(node.value);
        while (cmp != 0) {
            AvlNode avlNode = node = cmp < 0 ? node.left : node.right;
            if (node == null) {
                return false;
            }
            cmp = value.compareTo(node.value);
        }
        int LEFT = -1;
        boolean RIGHT = true;
        boolean NONE = false;
        int replaceFrom = 0;
        if (node.left != null && node.right == null) {
            replaceFrom = -1;
        } else if (node.right != null && node.left == null) {
            replaceFrom = 1;
        } else if (node.right != null && node.left != null) {
            replaceFrom = node.balance < 0 ? -1 : (node.balance > 0 ? 1 : -1);
        } else {
            if (node.parent == null) {
                this.tree = null;
                --this.size;
                this.recycleNode(node);
                return true;
            }
            if (node.parent.left == node) {
                node.parent.left = null;
            } else {
                node.parent.right = null;
            }
            AvlNode<T> dead = node;
            node = node.parent;
            this.recycleNode(dead);
            replaceFrom = 0;
        }
        if (replaceFrom != 0) {
            AvlNode leaf = null;
            if (replaceFrom == -1) {
                leaf = node.left;
                while (leaf.left != null || leaf.right != null) {
                    if (leaf.right != null) {
                        leaf = leaf.right;
                        continue;
                    }
                    leaf = AvlTreeSet.smallRightRotation(leaf);
                }
            } else if (replaceFrom == 1) {
                leaf = node.right;
                while (leaf.right != null || leaf.left != null) {
                    if (leaf.left != null) {
                        leaf = leaf.left;
                        continue;
                    }
                    leaf = AvlTreeSet.smallLeftRotation(leaf);
                }
            } else assert (false) : "should never happen";
            assert (leaf != null) : "replacement leaf should always exist at this point";
            if (leaf.parent.left == leaf) {
                leaf.parent.left = null;
            } else if (leaf.parent.right == leaf) {
                leaf.parent.right = null;
            } else assert (false) : "broken parent/child reference in the tree";
            node.value = leaf.value;
            node = leaf.parent;
            this.recycleNode(leaf);
        }
        this.rebalanceUp(node);
        --this.size;
        return true;
    }

    public final boolean contains(T value) {
        AvlNode<T> node = this.tree;
        while (node != null) {
            int cmp = value.compareTo(node.value);
            if (cmp < 0) {
                node = node.left;
                continue;
            }
            if (cmp > 0) {
                node = node.right;
                continue;
            }
            return true;
        }
        return false;
    }

    private static final <T extends Comparable<T>> void updateHeight(AvlNode<T> node) {
        int leftHeight = node.left == null ? -1 : node.left.height;
        int rightHeight = node.right == null ? -1 : node.right.height;
        node.height = 1 + (rightHeight > leftHeight ? rightHeight : leftHeight);
        node.balance = rightHeight - leftHeight;
    }

    private static final <T extends Comparable<T>> AvlNode<T> smallLeftRotation(AvlNode<T> node) {
        assert (node.balance > 0) : "null right child in smallLeft";
        AvlNode right = node.right;
        node.right = right.left;
        right.left = node;
        if (node.right != null) {
            node.right.parent = node;
        }
        right.parent = node.parent;
        if (right.parent != null) {
            if (right.parent.left == node) {
                node.parent.left = right;
            } else {
                node.parent.right = right;
            }
        }
        node.parent = right;
        AvlTreeSet.updateHeight(node);
        AvlTreeSet.updateHeight(right);
        return right;
    }

    private static final <T extends Comparable<T>> AvlNode<T> smallRightRotation(AvlNode<T> node) {
        assert (node.balance < 0) : "null left child in smallRight";
        AvlNode left = node.left;
        node.left = left.right;
        left.right = node;
        if (node.left != null) {
            node.left.parent = node;
        }
        left.parent = node.parent;
        if (left.parent != null) {
            if (left.parent.left == node) {
                node.parent.left = left;
            } else {
                node.parent.right = left;
            }
        }
        node.parent = left;
        AvlTreeSet.updateHeight(node);
        AvlTreeSet.updateHeight(left);
        return left;
    }

    private static final <T extends Comparable<T>> AvlNode<T> bigLeftRotation(AvlNode<T> node) {
        assert (node.right != null) : "null right child in bigLeft";
        if (node.right.balance < 0) {
            node.right = AvlTreeSet.smallRightRotation(node.right);
        }
        AvlTreeSet.updateHeight(node);
        return AvlTreeSet.smallLeftRotation(node);
    }

    private static final <T extends Comparable<T>> AvlNode<T> bigRightRotation(AvlNode<T> node) {
        assert (node.left != null) : "null right child in bigRight";
        if (node.left.balance > 0) {
            node.left = AvlTreeSet.smallLeftRotation(node.left);
        }
        AvlTreeSet.updateHeight(node);
        return AvlTreeSet.smallRightRotation(node);
    }
}

