/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.zstd;

import com.github.luben.zstd.ZstdDictDecompress;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdCodec;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ZstdHFileDecompressionContext
extends Compression.HFileDecompressionContext {
    public static final long FIXED_OVERHEAD = ClassSize.estimateBase(ZstdHFileDecompressionContext.class, (boolean)false);
    @Nullable
    private final ZstdDictDecompress dict;
    private final int dictId;
    private final boolean allowByteBuffDecompression;

    private ZstdHFileDecompressionContext(@Nullable ZstdDictDecompress dict, int dictId, boolean allowByteBuffDecompression) {
        this.dict = dict;
        this.dictId = dictId;
        this.allowByteBuffDecompression = allowByteBuffDecompression;
    }

    @Nullable
    public ZstdDictDecompress getDict() {
        return this.dict;
    }

    public int getDictId() {
        return this.dictId;
    }

    public boolean isAllowByteBuffDecompression() {
        return this.allowByteBuffDecompression;
    }

    public static ZstdHFileDecompressionContext fromConfiguration(Configuration conf) {
        boolean allowByteBuffDecompression = conf.getBoolean("hbase.io.compress.zstd.allowByteBuffDecompression", true);
        Pair<ZstdDictDecompress, Integer> dictAndId = ZstdCodec.getDecompressDictionary(conf);
        if (dictAndId != null) {
            return new ZstdHFileDecompressionContext((ZstdDictDecompress)dictAndId.getFirst(), (Integer)dictAndId.getSecond(), allowByteBuffDecompression);
        }
        return new ZstdHFileDecompressionContext(null, 0, allowByteBuffDecompression);
    }

    public void close() throws IOException {
        if (this.dict != null) {
            this.dict.close();
        }
    }

    public long heapSize() {
        return FIXED_OVERHEAD;
    }

    public String toString() {
        return "ZstdHFileDecompressionContext{dictId=" + this.dictId + ", allowByteBuffDecompression=" + this.allowByteBuffDecompression + '}';
    }
}

