/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.procedure.TestSCPBase;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSCPWithReplicasWithRSGroup
extends TestSCPBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSCPWithReplicasWithRSGroup.class);

    protected void setupConf(Configuration conf) {
        conf.setClass("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class, LoadBalancer.class);
        conf.set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName());
    }

    protected void startMiniCluster() throws Exception {
        this.util.startMiniCluster(4);
    }

    protected int getRegionReplication() {
        return 3;
    }

    @Test
    public void testCrashTargetRs() throws Exception {
        HMaster master = this.util.getHBaseCluster().getMaster();
        this.util.waitFor(60000L, () -> master.isInitialized() && ((RSGroupBasedLoadBalancer)master.getLoadBalancer()).isOnline());
        this.testRecoveryAndDoubleExecution(false, false);
    }
}

