/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceChecker.class);
    private String tagLine;
    private List<ResourceAnalyzer> ras = new ArrayList<ResourceAnalyzer>();
    private int[] initialValues;
    private int[] endingValues;

    public ResourceChecker(String tagLine) {
        this.tagLine = tagLine;
    }

    private void fillInit() {
        this.initialValues = new int[this.ras.size()];
        this.fill(Phase.INITIAL, this.initialValues);
    }

    private void fillEndings() {
        this.endingValues = new int[this.ras.size()];
        this.fill(Phase.END, this.endingValues);
    }

    private void fill(Phase phase, int[] vals) {
        int i = 0;
        for (ResourceAnalyzer ra : this.ras) {
            vals[i++] = ra.getVal(phase);
        }
    }

    public void checkInit() {
        this.check(this.initialValues);
    }

    private void checkEndings() {
        this.check(this.endingValues);
    }

    private void check(int[] vals) {
        int i = 0;
        for (ResourceAnalyzer ra : this.ras) {
            int cur;
            if ((cur = vals[i++]) < ra.getMin()) {
                LOG.warn(ra.getName() + "=" + cur + " is inferior to " + ra.getMin());
            }
            if (cur <= ra.getMax()) continue;
            LOG.warn(ra.getName() + "=" + cur + " is superior to " + ra.getMax());
        }
    }

    private void logInit() {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (ResourceAnalyzer ra : this.ras) {
            int cur = this.initialValues[i++];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ra.getName()).append("=").append(cur);
        }
        LOG.info("before: " + this.tagLine + " " + sb);
    }

    private void logEndings() {
        assert (this.initialValues.length == this.ras.size());
        assert (this.endingValues.length == this.ras.size());
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (ResourceAnalyzer ra : this.ras) {
            int curP = this.initialValues[i];
            int curN = this.endingValues[i++];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ra.getName()).append("=").append(curN).append(" (was ").append(curP).append(")");
            if (curN <= curP) continue;
            List<String> strings = ra.getStringsToLog();
            if (strings != null) {
                for (String s : strings) {
                    sb.append(s);
                }
            }
            sb.append(" - ").append(ra.getName()).append(" LEAK? -");
        }
        LOG.info("after: " + this.tagLine + " " + sb);
    }

    public void start() {
        if (this.ras.isEmpty()) {
            LOG.info("No resource analyzer");
            return;
        }
        this.fillInit();
        this.logInit();
        this.checkInit();
    }

    public void end() {
        if (this.ras.isEmpty()) {
            LOG.info("No resource analyzer");
            return;
        }
        if (this.initialValues == null) {
            LOG.warn("No initial values");
            return;
        }
        this.fillEndings();
        this.logEndings();
        this.checkEndings();
    }

    public void addResourceAnalyzer(ResourceAnalyzer ra) {
        this.ras.add(ra);
    }

    static abstract class ResourceAnalyzer {
        ResourceAnalyzer() {
        }

        public int getMax() {
            return Integer.MAX_VALUE;
        }

        public int getMin() {
            return Integer.MIN_VALUE;
        }

        public String getName() {
            String extName;
            String className = this.getClass().getSimpleName();
            if (className.endsWith(extName = ResourceAnalyzer.class.getSimpleName())) {
                return className.substring(0, className.length() - extName.length());
            }
            return className;
        }

        public abstract int getVal(Phase var1);

        public List<String> getStringsToLog() {
            return null;
        }
    }

    static enum Phase {
        INITIAL,
        INTERMEDIATE,
        END;

    }
}

