/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.factories.CalmMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.ConfigurableSlowDeterministicMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.DataIssuesMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.DistributedIssuesMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.MasterKillingMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.MobNoKillMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.NoKillMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.ServerAndDependenciesKillingMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.ServerKillingMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.SlowDeterministicMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.StressAssignmentManagerMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.UnbalanceMonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonkeyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MonkeyFactory.class);
    protected TableName tableName;
    protected Set<String> columnFamilies;
    protected IntegrationTestingUtility util;
    protected Properties properties = new Properties();
    public static final String CALM = "calm";
    public static final String SLOW_DETERMINISTIC = "slowDeterministic";
    public static final String UNBALANCE = "unbalance";
    public static final String SERVER_KILLING = "serverKilling";
    public static final String STRESS_AM = "stressAM";
    public static final String NO_KILL = "noKill";
    public static final String MASTER_KILLING = "masterKilling";
    public static final String MOB_NO_KILL = "mobNoKill";
    public static final String MOB_SLOW_DETERMINISTIC = "mobSlowDeterministic";
    public static final String SERVER_AND_DEPENDENCIES_KILLING = "serverAndDependenciesKilling";
    public static final String DISTRIBUTED_ISSUES = "distributedIssues";
    public static final String DATA_ISSUES = "dataIssues";
    public static final String CONFIGURABLE_SLOW_DETERMINISTIC = "configurableSlowDeterministic";
    public static Map<String, MonkeyFactory> FACTORIES = ImmutableMap.builder().put((Object)"calm", (Object)new CalmMonkeyFactory()).put((Object)"slowDeterministic", (Object)new SlowDeterministicMonkeyFactory()).put((Object)"unbalance", (Object)new UnbalanceMonkeyFactory()).put((Object)"serverKilling", (Object)new ServerKillingMonkeyFactory()).put((Object)"stressAM", (Object)new StressAssignmentManagerMonkeyFactory()).put((Object)"noKill", (Object)new NoKillMonkeyFactory()).put((Object)"masterKilling", (Object)new MasterKillingMonkeyFactory()).put((Object)"mobNoKill", (Object)new MobNoKillMonkeyFactory()).put((Object)"mobSlowDeterministic", (Object)new MobNoKillMonkeyFactory()).put((Object)"serverAndDependenciesKilling", (Object)new ServerAndDependenciesKillingMonkeyFactory()).put((Object)"distributedIssues", (Object)new DistributedIssuesMonkeyFactory()).put((Object)"dataIssues", (Object)new DataIssuesMonkeyFactory()).put((Object)"configurableSlowDeterministic", (Object)new ConfigurableSlowDeterministicMonkeyFactory()).build();

    public MonkeyFactory setTableName(TableName tableName) {
        this.tableName = tableName;
        return this;
    }

    public MonkeyFactory setColumnFamilies(Set<String> columnFamilies) {
        this.columnFamilies = columnFamilies;
        return this;
    }

    public MonkeyFactory setUtil(IntegrationTestingUtility util) {
        this.util = util;
        return this;
    }

    public MonkeyFactory setProperties(Properties props) {
        if (props != null) {
            this.properties = props;
        }
        return this;
    }

    public abstract ChaosMonkey build();

    public static MonkeyFactory getFactory(String factoryName) {
        MonkeyFactory fact = FACTORIES.get(factoryName);
        if (fact == null && factoryName != null && !factoryName.isEmpty()) {
            Class<?> klass = null;
            try {
                klass = Class.forName(factoryName);
                if (klass != null) {
                    LOG.info("Instantiating {}", (Object)klass.getName());
                    fact = (MonkeyFactory)ReflectionUtils.newInstance(klass, (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                LOG.error("Error trying to create " + factoryName + " could not load it by class name");
                return null;
            }
        }
        return fact;
    }
}

