/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingBatchSuspendResumeRsAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(RollingBatchSuspendResumeRsAction.class);
    private final float ratio;
    private final long sleepTime;
    private final int maxSuspendedServers;

    public RollingBatchSuspendResumeRsAction(long sleepTime, float ratio) {
        this(sleepTime, ratio, 5);
    }

    public RollingBatchSuspendResumeRsAction(long sleepTime, float ratio, int maxSuspendedServers) {
        this.ratio = ratio;
        this.sleepTime = sleepTime;
        this.maxSuspendedServers = maxSuspendedServers;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        this.getLogger().info("Performing action: Rolling batch suspending {}% of region servers", (Object)((int)(this.ratio * 100.0f)));
        List<ServerName> selectedServers = this.selectServers();
        ArrayDeque<ServerName> serversToBeSuspended = new ArrayDeque<ServerName>(selectedServers);
        ArrayDeque<ServerName> suspendedServers = new ArrayDeque<ServerName>();
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        while (!(serversToBeSuspended.isEmpty() && suspendedServers.isEmpty() || this.context.isStopping())) {
            SuspendOrResume action = serversToBeSuspended.isEmpty() ? SuspendOrResume.RESUME : (suspendedServers.isEmpty() ? SuspendOrResume.SUSPEND : (suspendedServers.size() >= this.maxSuspendedServers ? SuspendOrResume.RESUME : (((Random)rand).nextBoolean() ? SuspendOrResume.SUSPEND : SuspendOrResume.RESUME)));
            switch (action) {
                case SUSPEND: {
                    ServerName server = (ServerName)serversToBeSuspended.remove();
                    try {
                        this.suspendRs(server);
                    }
                    catch (Shell.ExitCodeException e) {
                        LOG.warn("Problem suspending but presume successful; code={}", (Object)e.getExitCode(), (Object)e);
                    }
                    suspendedServers.add(server);
                    break;
                }
                case RESUME: {
                    ServerName server = (ServerName)suspendedServers.remove();
                    try {
                        this.resumeRs(server);
                        break;
                    }
                    catch (Shell.ExitCodeException e) {
                        LOG.info("Problem resuming, will retry; code={}", (Object)e.getExitCode(), (Object)e);
                    }
                }
            }
            this.getLogger().info("Sleeping for:{}", (Object)this.sleepTime);
            Threads.sleep((long)this.sleepTime);
        }
    }

    protected List<ServerName> selectServers() throws IOException {
        return PolicyBasedChaosMonkey.selectRandomItems(this.getCurrentServers(), this.ratio);
    }

    static enum SuspendOrResume {
        SUSPEND,
        RESUME;

    }
}

