/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.actions.MoveRegionsOfTableAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveRandomRegionOfTableAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(MoveRandomRegionOfTableAction.class);
    private final long sleepTime;
    private final TableName tableName;

    public MoveRandomRegionOfTableAction(TableName tableName) {
        this(-1L, tableName);
    }

    public MoveRandomRegionOfTableAction(long sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        this.getLogger().info("Performing action: Move random region of table " + this.tableName);
        List regions = admin.getRegions(this.tableName);
        if (regions == null || regions.isEmpty()) {
            this.getLogger().info("Table " + this.tableName + " doesn't have regions to move");
            return;
        }
        RegionInfo region = PolicyBasedChaosMonkey.selectRandomItem(regions.toArray(new RegionInfo[0]));
        this.getLogger().debug("Move random region {}", (Object)region.getRegionNameAsString());
        MoveRegionsOfTableAction.moveRegion(admin, MoveRegionsOfTableAction.getServers(admin), region, this.getLogger());
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

