/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultCompactor
extends Compactor<StoreFileWriter> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCompactor.class);
    private final Compactor.CellSinkFactory<StoreFileWriter> writerFactory = new Compactor.CellSinkFactory<StoreFileWriter>(){

        @Override
        public StoreFileWriter createWriter(InternalScanner scanner, Compactor.FileDetails fd, boolean shouldDropBehind, boolean major, Consumer<Path> writerCreationTracker) throws IOException {
            return DefaultCompactor.this.createWriter(fd, shouldDropBehind, major, writerCreationTracker);
        }
    };

    public DefaultCompactor(Configuration conf, HStore store) {
        super(conf, store);
    }

    public List<Path> compact(CompactionRequestImpl request, ThroughputController throughputController, User user) throws IOException {
        return this.compact(request, this.defaultScannerFactory, this.writerFactory, throughputController, user);
    }

    @Override
    protected List<Path> commitWriter(StoreFileWriter writer, Compactor.FileDetails fd, CompactionRequestImpl request) throws IOException {
        List<Path> newFiles = writer.getPaths();
        writer.appendMetadata(fd.maxSeqId, request.isAllFiles(), request.getFiles());
        writer.close();
        return newFiles;
    }

    @Override
    protected final void abortWriter(StoreFileWriter writer) throws IOException {
        List<Path> leftoverFiles = writer.getPaths();
        try {
            writer.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close the writer after an unfinished compaction.", (Throwable)e);
        }
        try {
            for (Path path : leftoverFiles) {
                this.store.getFileSystem().delete(path, false);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to delete the leftover file {} after an unfinished compaction.", leftoverFiles, (Object)e);
        }
    }
}

