/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.NodeLabel;

public final class NodeLabelsUtils {
    private static final Log LOG = LogFactory.getLog(NodeLabelsUtils.class);

    private NodeLabelsUtils() {
    }

    public static Set<String> convertToStringSet(Set<NodeLabel> nodeLabels) {
        if (null == nodeLabels) {
            return null;
        }
        HashSet<String> labels = new HashSet<String>();
        for (NodeLabel label : nodeLabels) {
            labels.add(label.getName());
        }
        return labels;
    }

    public static void verifyCentralizedNodeLabelConfEnabled(String operation, boolean isCentralizedNodeLabelConfiguration) throws IOException {
        if (!isCentralizedNodeLabelConfiguration) {
            String msg = String.format("Error when invoke method=%s because centralized node label configuration is not enabled.", operation);
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
    }
}

