/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SharedCacheUtil {
    private static final Log LOG = LogFactory.getLog(SharedCacheUtil.class);

    @InterfaceAudience.Private
    public static int getCacheDepth(Configuration conf) {
        int cacheDepth = conf.getInt("yarn.sharedcache.nested-level", 3);
        if (cacheDepth <= 0) {
            LOG.warn((Object)("Specified cache depth was less than or equal to zero. Using default value instead. Default: 3, Specified: " + cacheDepth));
            cacheDepth = 3;
        }
        return cacheDepth;
    }

    @InterfaceAudience.Private
    public static String getCacheEntryPath(int cacheDepth, String cacheRoot, String checksum) {
        if (cacheDepth <= 0) {
            throw new IllegalArgumentException("The cache depth must be greater than 0. Passed value: " + cacheDepth);
        }
        if (checksum.length() < cacheDepth) {
            throw new IllegalArgumentException("The checksum passed was too short: " + checksum);
        }
        StringBuilder sb = new StringBuilder(cacheRoot);
        for (int i = 0; i < cacheDepth; ++i) {
            sb.append('/');
            sb.append(checksum.charAt(i));
        }
        sb.append('/').append(checksum);
        return sb.toString();
    }

    @InterfaceAudience.Private
    public static String getCacheEntryGlobPattern(int depth) {
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            pattern.append("*/");
        }
        pattern.append("*");
        return pattern.toString();
    }
}

