/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.shaded.com.sun.jersey.api.container.ContainerException;
import org.apache.hadoop.shaded.com.sun.jersey.api.model.Parameter;
import org.apache.hadoop.shaded.com.sun.jersey.core.reflection.ReflectionHelper;
import org.apache.hadoop.shaded.com.sun.jersey.impl.ImplMessages;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.CollectionStringExtractor;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.CollectionStringReaderExtractor;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorProvider;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.PrimitiveMapper;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.PrimitiveValueOfExtractor;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.StringExtractor;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.StringReaderExtractor;
import org.apache.hadoop.shaded.com.sun.jersey.spi.StringReader;
import org.apache.hadoop.shaded.com.sun.jersey.spi.StringReaderWorkers;

public final class MultivaluedParameterExtractorFactory
implements MultivaluedParameterExtractorProvider {
    private final StringReaderWorkers w;

    public MultivaluedParameterExtractorFactory(StringReaderWorkers w) {
        this.w = w;
    }

    @Override
    public MultivaluedParameterExtractor getWithoutDefaultValue(Parameter p) {
        return this.process(this.w, null, p.getParameterClass(), p.getParameterType(), p.getAnnotations(), p.getSourceName());
    }

    @Override
    public MultivaluedParameterExtractor get(Parameter p) {
        return this.process(this.w, p.getDefaultValue(), p.getParameterClass(), p.getParameterType(), p.getAnnotations(), p.getSourceName());
    }

    private MultivaluedParameterExtractor process(StringReaderWorkers w, String defaultValue, Class<?> parameter, Type parameterType, Annotation[] annotations, String parameterName) {
        if (parameter == List.class || parameter == Set.class || parameter == SortedSet.class) {
            ReflectionHelper.TypeClassPair tcp = ReflectionHelper.getTypeArgumentAndClass((Type)parameterType);
            if (tcp == null || tcp.c == String.class) {
                return CollectionStringExtractor.getInstance(parameter, parameterName, defaultValue);
            }
            StringReader sr = w.getStringReader(tcp.c, tcp.t, annotations);
            if (sr == null) {
                return null;
            }
            try {
                return CollectionStringReaderExtractor.getInstance(parameter, sr, parameterName, defaultValue);
            }
            catch (Exception e) {
                throw new ContainerException("Could not process parameter type " + parameter, e);
            }
        }
        if (parameter == String.class) {
            return new StringExtractor(parameterName, defaultValue);
        }
        if (parameter.isPrimitive()) {
            if ((parameter = PrimitiveMapper.primitiveToClassMap.get(parameter)) == null) {
                return null;
            }
            Method valueOf = (Method)AccessController.doPrivileged(ReflectionHelper.getValueOfStringMethodPA((Class)parameter));
            if (valueOf != null) {
                try {
                    Object defaultDefaultValue = PrimitiveMapper.primitiveToDefaultValueMap.get(parameter);
                    return new PrimitiveValueOfExtractor(valueOf, parameterName, defaultValue, defaultDefaultValue);
                }
                catch (Exception e) {
                    throw new ContainerException(ImplMessages.DEFAULT_COULD_NOT_PROCESS_METHOD((Object)defaultValue, (Object)valueOf));
                }
            }
        } else {
            StringReader sr = w.getStringReader(parameter, parameterType, annotations);
            if (sr == null) {
                return null;
            }
            try {
                return new StringReaderExtractor(sr, parameterName, defaultValue);
            }
            catch (Exception e) {
                throw new ContainerException("Could not process parameter type " + parameter, e);
            }
        }
        return null;
    }
}

