/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.HarFs;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ExtendedLogMetaRequest;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAggregationMetaCollector {
    private static final Logger LOG = LoggerFactory.getLogger(LogAggregationMetaCollector.class);
    private final ExtendedLogMetaRequest logsRequest;
    private final Configuration conf;

    public LogAggregationMetaCollector(ExtendedLogMetaRequest logsRequest, Configuration conf) {
        this.logsRequest = logsRequest;
        this.conf = conf;
    }

    public List<ContainerLogMeta> collect(LogAggregationFileController fileController) throws IOException {
        ArrayList<ContainerLogMeta> containersLogMeta = new ArrayList<ContainerLogMeta>();
        RemoteIterator<FileStatus> appDirs = fileController.getApplicationDirectoriesOfUser(this.logsRequest.getUser());
        while (appDirs.hasNext()) {
            FileStatus currentAppDir = appDirs.next();
            if (this.logsRequest.getAppId() != null && !this.logsRequest.getAppId().equals(currentAppDir.getPath().getName())) continue;
            ApplicationId appId = ApplicationId.fromString(currentAppDir.getPath().getName());
            RemoteIterator<FileStatus> nodeFiles = fileController.getNodeFilesOfApplicationDirectory(currentAppDir);
            while (nodeFiles.hasNext()) {
                FileStatus currentNodeFile = nodeFiles.next();
                if (!this.logsRequest.getNodeId().match(currentNodeFile.getPath().getName())) continue;
                if (currentNodeFile.getPath().getName().equals(this.logsRequest.getAppId() + ".har")) {
                    Path p = new Path("har:///" + currentNodeFile.getPath().toUri().getRawPath());
                    nodeFiles = HarFs.get(p.toUri(), this.conf).listStatusIterator(p);
                    continue;
                }
                try {
                    Map<String, List<ContainerLogFileInfo>> metaFiles = fileController.getLogMetaFilesOfNode(this.logsRequest, currentNodeFile, appId);
                    if (metaFiles == null) continue;
                    metaFiles.entrySet().removeIf(entry -> this.logsRequest.getContainerId() != null && !this.logsRequest.getContainerId().equals(entry.getKey()));
                    containersLogMeta.addAll(this.createContainerLogMetas(currentNodeFile.getPath().getName(), metaFiles));
                }
                catch (IOException ioe) {
                    LOG.warn("Can not get log meta from the log file:" + currentNodeFile.getPath() + "\n" + ioe.getMessage());
                }
            }
        }
        return containersLogMeta;
    }

    private List<ContainerLogMeta> createContainerLogMetas(String nodeId, Map<String, List<ContainerLogFileInfo>> metaFiles) {
        ArrayList<ContainerLogMeta> containerLogMetas = new ArrayList<ContainerLogMeta>();
        for (Map.Entry<String, List<ContainerLogFileInfo>> containerLogs : metaFiles.entrySet()) {
            ContainerLogMeta containerLogMeta = new ContainerLogMeta(containerLogs.getKey(), nodeId);
            for (ContainerLogFileInfo file : containerLogs.getValue()) {
                boolean isFileNameMatches = this.logsRequest.getFileName().match(file.getFileName());
                boolean fileSizeComparison = this.logsRequest.getFileSize().match(file.getFileSize());
                boolean modificationTimeComparison = this.logsRequest.getModificationTime().match(file.getLastModifiedTime());
                if (!isFileNameMatches || !fileSizeComparison || !modificationTimeComparison) continue;
                containerLogMeta.getContainerLogMeta().add(file);
            }
            if (containerLogMeta.getContainerLogMeta().isEmpty()) continue;
            containerLogMetas.add(containerLogMeta);
        }
        return containerLogMetas;
    }
}

