/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public final class CombinedHostsFileWriter {
    private CombinedHostsFileWriter() {
    }

    public static void writeFile(String hostsFile, Set<DatanodeAdminProperties> allDNs) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        try (OutputStreamWriter output = new OutputStreamWriter(Files.newOutputStream(Paths.get(hostsFile, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
            objectMapper.writeValue((Writer)output, allDNs);
        }
    }
}

