/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResult;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ClientSideRequestStatistics {
    private static final int MAX_SUPPLEMENTAL_REQUESTS_FOR_TO_STRING = 10;
    private static final DateTimeFormatter responseTimeFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm:ss.SSS").withLocale(Locale.US);
    private ZonedDateTime requestStartTime = ZonedDateTime.now(ZoneOffset.UTC);
    private ZonedDateTime requestEndTime = ZonedDateTime.now(ZoneOffset.UTC);
    private List<StoreResponseStatistics> responseStatisticsList = new ArrayList<StoreResponseStatistics>();
    private List<StoreResponseStatistics> supplementalResponseStatisticsList = new ArrayList<StoreResponseStatistics>();
    private Map<String, AddressResolutionStatistics> addressResolutionStatistics = new HashMap<String, AddressResolutionStatistics>();
    private List<URI> contactedReplicas = new ArrayList<URI>();
    private Set<URI> failedReplicas = new HashSet<URI>();
    private Set<URI> regionsContacted = new HashSet<URI>();

    public Duration getRequestLatency() {
        return Duration.between(this.requestStartTime, this.requestEndTime);
    }

    private boolean isCPUOverloaded() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordResponse(RxDocumentServiceRequest request, StoreResult storeResult) {
        ZonedDateTime responseTime = ZonedDateTime.now(ZoneOffset.UTC);
        StoreResponseStatistics storeResponseStatistics = new StoreResponseStatistics();
        storeResponseStatistics.requestResponseTime = responseTime;
        storeResponseStatistics.storeResult = storeResult;
        storeResponseStatistics.requestOperationType = request.getOperationType();
        storeResponseStatistics.requestResourceType = request.getResourceType();
        URI locationEndPoint = null;
        if (request.requestContext.locationEndpointToRoute != null) {
            try {
                locationEndPoint = request.requestContext.locationEndpointToRoute.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTime)) {
                this.requestEndTime = responseTime;
            }
            if (locationEndPoint != null) {
                this.regionsContacted.add(locationEndPoint);
            }
            if (storeResponseStatistics.requestOperationType == OperationType.Head || storeResponseStatistics.requestOperationType == OperationType.HeadFeed) {
                this.supplementalResponseStatisticsList.add(storeResponseStatistics);
            } else {
                this.responseStatisticsList.add(storeResponseStatistics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String recordAddressResolutionStart(URI targetEndpoint) {
        String identifier = Utils.randomUUID().toString();
        AddressResolutionStatistics resolutionStatistics = new AddressResolutionStatistics();
        resolutionStatistics.startTime = ZonedDateTime.now(ZoneOffset.UTC);
        resolutionStatistics.endTime = ZonedDateTime.of(LocalDateTime.MAX, ZoneOffset.UTC);
        resolutionStatistics.targetEndpoint = targetEndpoint == null ? "<NULL>" : targetEndpoint.toString();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            this.addressResolutionStatistics.put(identifier, resolutionStatistics);
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordAddressResolutionEnd(String identifier) {
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            return;
        }
        ZonedDateTime responseTime = ZonedDateTime.now(ZoneOffset.UTC);
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (!this.addressResolutionStatistics.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier " + identifier + " does not exist. Please call start before calling end");
            }
            if (responseTime.isAfter(this.requestEndTime)) {
                this.requestEndTime = responseTime;
            }
            AddressResolutionStatistics resolutionStatistics = this.addressResolutionStatistics.get(identifier);
            resolutionStatistics.endTime = responseTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            stringBuilder.append("RequestStartTime: ").append("\"").append(this.requestStartTime.format(responseTimeFormatter)).append("\"").append(", ").append("RequestEndTime: ").append("\"").append(this.requestEndTime.format(responseTimeFormatter)).append("\"").append(", ").append("Duration: ").append(Duration.between(this.requestStartTime, this.requestEndTime).toMillis()).append(" ms, ").append("Number of regions attempted: ").append(this.regionsContacted.isEmpty() ? 1 : this.regionsContacted.size()).append(System.lineSeparator());
            for (StoreResponseStatistics storeResponseStatistics : this.responseStatisticsList) {
                stringBuilder.append(storeResponseStatistics.toString()).append(System.lineSeparator());
            }
            for (AddressResolutionStatistics value : this.addressResolutionStatistics.values()) {
                stringBuilder.append(value.toString()).append(System.lineSeparator());
            }
            int supplementalResponseStatisticsListCount = this.supplementalResponseStatisticsList.size();
            int initialIndex = Math.max(supplementalResponseStatisticsListCount - 10, 0);
            if (initialIndex != 0) {
                stringBuilder.append("  -- Displaying only the last ").append(10).append(" head/headfeed requests. Total head/headfeed requests: ").append(supplementalResponseStatisticsListCount);
            }
            for (int i = initialIndex; i < supplementalResponseStatisticsListCount; ++i) {
                stringBuilder.append(this.supplementalResponseStatisticsList.get(i).toString()).append(System.lineSeparator());
            }
        }
        String requestStatsString = stringBuilder.toString();
        if (!requestStatsString.isEmpty()) {
            return System.lineSeparator() + requestStatsString;
        }
        return "";
    }

    public List<URI> getContactedReplicas() {
        return this.contactedReplicas;
    }

    public void setContactedReplicas(List<URI> contactedReplicas) {
        this.contactedReplicas = contactedReplicas;
    }

    public Set<URI> getFailedReplicas() {
        return this.failedReplicas;
    }

    public void setFailedReplicas(Set<URI> failedReplicas) {
        this.failedReplicas = failedReplicas;
    }

    public Set<URI> getRegionsContacted() {
        return this.regionsContacted;
    }

    public void setRegionsContacted(Set<URI> regionsContacted) {
        this.regionsContacted = regionsContacted;
    }

    private static String formatDateTime(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.format(responseTimeFormatter);
    }

    private class AddressResolutionStatistics {
        private ZonedDateTime startTime;
        private ZonedDateTime endTime;
        private String targetEndpoint;

        AddressResolutionStatistics() {
        }

        public String toString() {
            return "AddressResolutionStatistics{startTime=\"" + ClientSideRequestStatistics.formatDateTime(this.startTime) + "\", endTime=\"" + ClientSideRequestStatistics.formatDateTime(this.endTime) + "\", targetEndpoint='" + this.targetEndpoint + '\'' + '}';
        }
    }

    private class StoreResponseStatistics {
        private ZonedDateTime requestResponseTime;
        private StoreResult storeResult;
        private ResourceType requestResourceType;
        private OperationType requestOperationType;

        private StoreResponseStatistics() {
        }

        public String toString() {
            return "StoreResponseStatistics{requestResponseTime=\"" + ClientSideRequestStatistics.formatDateTime(this.requestResponseTime) + "\", storeResult=" + this.storeResult + ", requestResourceType=" + (Object)((Object)this.requestResourceType) + ", requestOperationType=" + (Object)((Object)this.requestOperationType) + '}';
        }
    }
}

