/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;

public class QueueAppLifetimeAndLimitSettings {
    private final long maxApplicationLifetime;
    private final long defaultApplicationLifetime;
    private boolean defaultAppLifetimeWasSpecifiedInConfig = false;
    private int maxParallelApps;

    public QueueAppLifetimeAndLimitSettings(CapacitySchedulerConfiguration configuration, AbstractCSQueue q, QueuePath queuePath) {
        this.maxParallelApps = configuration.getMaxParallelAppsForQueue(queuePath.getFullPath());
        this.maxApplicationLifetime = this.getInheritedMaxAppLifetime(q, configuration);
        this.defaultApplicationLifetime = this.setupInheritedDefaultAppLifetime(q, queuePath, configuration, this.maxApplicationLifetime);
    }

    private long getInheritedMaxAppLifetime(CSQueue q, CapacitySchedulerConfiguration conf) {
        CSQueue parentQ = q.getParent();
        long maxAppLifetime = conf.getMaximumLifetimePerQueue(q.getQueuePath());
        if (q.getQueuePathObject().isRoot()) {
            return maxAppLifetime;
        }
        long parentsMaxAppLifetime = parentQ.getMaximumApplicationLifetime();
        return maxAppLifetime >= 0L ? maxAppLifetime : parentsMaxAppLifetime;
    }

    private long setupInheritedDefaultAppLifetime(CSQueue q, QueuePath queuePath, CapacitySchedulerConfiguration conf, long myMaxAppLifetime) {
        CSQueue parentQ = q.getParent();
        long defaultAppLifetime = conf.getDefaultLifetimePerQueue(queuePath.getFullPath());
        boolean bl = this.defaultAppLifetimeWasSpecifiedInConfig = defaultAppLifetime >= 0L || !queuePath.isRoot() && parentQ.getDefaultAppLifetimeWasSpecifiedInConfig();
        if (queuePath.isRoot()) {
            return defaultAppLifetime;
        }
        long parentsDefaultAppLifetime = parentQ.getDefaultApplicationLifetime();
        if (defaultAppLifetime < 0L) {
            defaultAppLifetime = this.defaultAppLifetimeWasSpecifiedInConfig ? Math.min(parentsDefaultAppLifetime, myMaxAppLifetime) : myMaxAppLifetime;
        }
        if (myMaxAppLifetime > 0L && defaultAppLifetime > myMaxAppLifetime) {
            throw new YarnRuntimeException("Default lifetime " + defaultAppLifetime + " can't exceed maximum lifetime " + myMaxAppLifetime);
        }
        if (defaultAppLifetime <= 0L) {
            defaultAppLifetime = myMaxAppLifetime;
        }
        return defaultAppLifetime;
    }

    public int getMaxParallelApps() {
        return this.maxParallelApps;
    }

    public void setMaxParallelApps(int maxParallelApps) {
        this.maxParallelApps = maxParallelApps;
    }

    public long getMaxApplicationLifetime() {
        return this.maxApplicationLifetime;
    }

    public long getDefaultApplicationLifetime() {
        return this.defaultApplicationLifetime;
    }

    public boolean isDefaultAppLifetimeWasSpecifiedInConfig() {
        return this.defaultAppLifetimeWasSpecifiedInConfig;
    }
}

