/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.chain;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.lib.chain.ChainMapper;
import org.apache.hadoop.mapreduce.lib.chain.ChainReducer;
import org.apache.hadoop.mapreduce.lib.map.TokenCounterMapper;
import org.apache.hadoop.mapreduce.lib.reduce.IntSumReducer;
import org.junit.Assert;
import org.junit.Test;

public class TestSingleElementChain
extends HadoopTestCase {
    private static String localPathRoot = System.getProperty("test.build.data", "/tmp");

    public TestSingleElementChain() throws IOException {
        super(1, 4, 1, 1);
    }

    @Test
    public void testNoChain() throws Exception {
        Path inDir = new Path(localPathRoot, "testing/chain/input");
        Path outDir = new Path(localPathRoot, "testing/chain/output");
        String input = "a\nb\na\n";
        String expectedOutput = "a\t2\nb\t1\n";
        JobConf conf = this.createJobConf();
        Job job = MapReduceTestUtil.createJob((Configuration)conf, inDir, outDir, 1, 1, input);
        job.setJobName("chain");
        ChainMapper.addMapper((Job)job, TokenCounterMapper.class, Object.class, Text.class, Text.class, IntWritable.class, null);
        ChainReducer.setReducer((Job)job, IntSumReducer.class, Text.class, IntWritable.class, Text.class, IntWritable.class, null);
        job.waitForCompletion(true);
        Assert.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
        Assert.assertEquals((String)"Outputs doesn't match", (Object)expectedOutput, (Object)MapReduceTestUtil.readOutput(outDir, (Configuration)conf));
    }
}

