/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import java.util.Locale;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public enum ConfigFormat {
    JSON("json"),
    PROPERTIES("properties"),
    XML("xml"),
    HADOOP_XML("hadoop_xml"),
    TEMPLATE("template"),
    YAML("yaml");

    private final String suffix;

    private ConfigFormat(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return this.suffix;
    }

    public static ConfigFormat resolve(String type) {
        for (ConfigFormat format : ConfigFormat.values()) {
            if (!format.getSuffix().equals(type.toLowerCase(Locale.ENGLISH))) continue;
            return format;
        }
        return null;
    }
}

