/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.impl.prefetch.BlockCache;
import org.apache.hadoop.fs.impl.prefetch.EmptyPrefetchingStatistics;
import org.apache.hadoop.fs.impl.prefetch.PrefetchingStatistics;
import org.apache.hadoop.fs.impl.prefetch.SingleFilePerBlockCache;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockCache
extends AbstractHadoopTestBase {
    private static final int BUFFER_SIZE = 16;
    private static final Configuration CONF = new Configuration();

    @Test
    public void testArgChecks() throws Exception {
        SingleFilePerBlockCache cache = new SingleFilePerBlockCache((PrefetchingStatistics)EmptyPrefetchingStatistics.getInstance(), 2, null);
        ByteBuffer buffer = ByteBuffer.allocate(16);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'buffer' must not be null", () -> TestBlockCache.lambda$testArgChecks$0((BlockCache)cache));
        LambdaTestUtils.intercept(NullPointerException.class, () -> new SingleFilePerBlockCache(null, 2, null));
    }

    @Test
    public void testPutAndGet() throws Exception {
        SingleFilePerBlockCache cache = new SingleFilePerBlockCache((PrefetchingStatistics)EmptyPrefetchingStatistics.getInstance(), 2, null);
        ByteBuffer buffer1 = ByteBuffer.allocate(16);
        for (byte i = 0; i < 16; i = (byte)(i + 1)) {
            buffer1.put(i);
        }
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertFalse((boolean)cache.containsBlock(0));
        cache.put(0, buffer1, CONF, new LocalDirAllocator("hadoop.tmp.dir"));
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertTrue((boolean)cache.containsBlock(0));
        ByteBuffer buffer2 = ByteBuffer.allocate(16);
        cache.get(0, buffer2);
        Assert.assertNotSame((Object)buffer1, (Object)buffer2);
        this.assertBuffersEqual(buffer1, buffer2);
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertFalse((boolean)cache.containsBlock(1));
        cache.put(1, buffer1, CONF, new LocalDirAllocator("hadoop.tmp.dir"));
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertTrue((boolean)cache.containsBlock(1));
        ByteBuffer buffer3 = ByteBuffer.allocate(16);
        cache.get(1, buffer3);
        Assert.assertNotSame((Object)buffer1, (Object)buffer3);
        this.assertBuffersEqual(buffer1, buffer3);
    }

    private void assertBuffersEqual(ByteBuffer buffer1, ByteBuffer buffer2) {
        Assert.assertNotNull((Object)buffer1);
        Assert.assertNotNull((Object)buffer2);
        Assert.assertEquals((long)buffer1.limit(), (long)buffer2.limit());
        Assert.assertEquals((long)16L, (long)buffer1.limit());
        for (int i = 0; i < 16; ++i) {
            Assert.assertEquals((long)buffer1.get(i), (long)buffer2.get(i));
        }
    }

    private static /* synthetic */ void lambda$testArgChecks$0(BlockCache cache) throws Exception {
        cache.put(42, null, null, null);
    }
}

