/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContextValidator;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.router.AbstractRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;

public class HashBasedRouterPolicy
extends AbstractRouterPolicy {
    @Override
    public void reinitialize(FederationPolicyInitializationContext federationPolicyContext) throws FederationPolicyInitializationException {
        FederationPolicyInitializationContextValidator.validate(federationPolicyContext, this.getClass().getCanonicalName());
        this.setPolicyContext(federationPolicyContext);
    }

    @Override
    protected SubClusterId chooseSubCluster(String queue, Map<SubClusterId, SubClusterInfo> preSelectSubclusters) throws YarnException {
        int chosenPosition = Math.abs(queue.hashCode() % preSelectSubclusters.size());
        ArrayList<SubClusterId> list = new ArrayList<SubClusterId>(preSelectSubclusters.keySet());
        Collections.sort(list);
        return (SubClusterId)list.get(chosenPosition);
    }
}

