/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.common;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTrie {
    private static final Logger LOG = LoggerFactory.getLogger(PathTrie.class);
    private final TrieNode rootNode;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public PathTrie() {
        this.rootNode = new TrieNode(null, "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPath(String path) {
        Objects.requireNonNull(path, "Path cannot be null");
        if (path.length() == 0) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        String[] pathComponents = PathTrie.split(path);
        this.writeLock.lock();
        try {
            TrieNode parent = this.rootNode;
            for (String part : pathComponents) {
                TrieNode child = parent.getChild(part);
                if (child == null) {
                    child = new TrieNode(parent, part);
                    parent.addChild(part, child);
                }
                parent = child;
            }
            parent.setProperty(true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePath(String path) {
        Objects.requireNonNull(path, "Path cannot be null");
        if (path.length() == 0) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        String[] pathComponents = PathTrie.split(path);
        this.writeLock.lock();
        try {
            TrieNode parent = this.rootNode;
            for (String part : pathComponents) {
                if (parent.getChild(part) == null) {
                    return;
                }
                parent = parent.getChild(part);
                LOG.debug("{}", (Object)parent);
            }
            TrieNode realParent = parent.getParent();
            realParent.deleteChild(parent.getValue());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsNode(String path) {
        Objects.requireNonNull(path, "Path cannot be null");
        if (path.length() == 0) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        String[] pathComponents = PathTrie.split(path);
        this.readLock.lock();
        try {
            TrieNode parent = this.rootNode;
            for (String part : pathComponents) {
                if (parent.getChild(part) == null) {
                    boolean bl = false;
                    return bl;
                }
                parent = parent.getChild(part);
                LOG.debug("{}", (Object)parent);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findMaxPrefix(String path) {
        Objects.requireNonNull(path, "Path cannot be null");
        String[] pathComponents = PathTrie.split(path);
        this.readLock.lock();
        try {
            TrieNode parent = this.rootNode;
            TrieNode deepestPropertyNode = null;
            for (String element : pathComponents) {
                if ((parent = parent.getChild(element)) == null) {
                    LOG.debug("{}", (Object)element);
                    break;
                }
                if (!parent.hasProperty()) continue;
                deepestPropertyNode = parent;
            }
            if (deepestPropertyNode == null) {
                String string = "/";
                return string;
            }
            ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
            TrieNode node = deepestPropertyNode;
            while (node != this.rootNode) {
                arrayDeque.offerFirst(node.getValue());
                node = node.parent;
            }
            String string = "/" + String.join((CharSequence)"/", arrayDeque);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.rootNode.getChildren().clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static String[] split(String path) {
        return (String[])Stream.of(path.split("/")).filter(t -> !t.trim().isEmpty()).toArray(String[]::new);
    }

    static class TrieNode {
        final String value;
        final Map<String, TrieNode> children;
        boolean property;
        TrieNode parent;

        private TrieNode(TrieNode parent, String value) {
            this.value = value;
            this.parent = parent;
            this.property = false;
            this.children = new HashMap<String, TrieNode>(4);
        }

        TrieNode getParent() {
            return this.parent;
        }

        void setParent(TrieNode parent) {
            this.parent = parent;
        }

        void setProperty(boolean prop) {
            this.property = prop;
        }

        boolean hasProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        void addChild(String childName, TrieNode node) {
            this.children.putIfAbsent(childName, node);
        }

        void deleteChild(String childName) {
            this.children.computeIfPresent(childName, (key, childNode) -> {
                childNode.setProperty(false);
                if (childNode.isLeafNode()) {
                    childNode.setParent(null);
                    return null;
                }
                return childNode;
            });
        }

        TrieNode getChild(String childName) {
            return this.children.get(childName);
        }

        Collection<String> getChildren() {
            return this.children.keySet();
        }

        boolean isLeafNode() {
            return this.children.isEmpty();
        }

        public String toString() {
            return "TrieNode [name=" + this.value + ", property=" + this.property + ", children=" + this.children.keySet() + "]";
        }
    }
}

