/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.xml.bind.v2.runtime.reflect.opt;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.com.sun.xml.bind.Util;
import org.apache.hadoop.shaded.com.sun.xml.bind.v2.bytecode.ClassTailor;
import org.apache.hadoop.shaded.com.sun.xml.bind.v2.model.core.TypeInfo;
import org.apache.hadoop.shaded.com.sun.xml.bind.v2.model.runtime.RuntimeClassInfo;
import org.apache.hadoop.shaded.com.sun.xml.bind.v2.model.runtime.RuntimePropertyInfo;
import org.apache.hadoop.shaded.com.sun.xml.bind.v2.runtime.reflect.Accessor;
import org.apache.hadoop.shaded.com.sun.xml.bind.v2.runtime.reflect.TransducedAccessor;
import org.apache.hadoop.shaded.com.sun.xml.bind.v2.runtime.reflect.opt.AccessorInjector;
import org.apache.hadoop.shaded.com.sun.xml.bind.v2.runtime.reflect.opt.Bean;
import org.apache.hadoop.shaded.com.sun.xml.bind.v2.runtime.reflect.opt.TransducedAccessor_field_Byte;
import org.apache.hadoop.shaded.com.sun.xml.bind.v2.runtime.reflect.opt.TransducedAccessor_method_Byte;

public abstract class OptimizedTransducedAccessorFactory {
    private static final Logger logger = Util.getClassLogger();
    private static final String fieldTemplateName;
    private static final String methodTemplateName;
    private static final Map<Class, String> suffixMap;

    private OptimizedTransducedAccessorFactory() {
    }

    public static final TransducedAccessor get(RuntimePropertyInfo prop) {
        Accessor acc = prop.getAccessor();
        Class opt = null;
        TypeInfo parent = prop.parent();
        if (!(parent instanceof RuntimeClassInfo)) {
            return null;
        }
        Class dc = (Class)((RuntimeClassInfo)parent).getClazz();
        String newClassName = ClassTailor.toVMClassName(dc) + "_JaxbXducedAccessor_" + prop.getName();
        if (acc instanceof Accessor.FieldReflection) {
            Accessor.FieldReflection racc = (Accessor.FieldReflection)acc;
            Field field = racc.f;
            int mods = field.getModifiers();
            if (Modifier.isPrivate(mods) || Modifier.isFinal(mods)) {
                return null;
            }
            Class<?> t = field.getType();
            if (t.isPrimitive()) {
                opt = AccessorInjector.prepare((Class)dc, (String)(fieldTemplateName + suffixMap.get(t)), (String)newClassName, (String[])new String[]{ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(dc), "f_" + t.getName(), field.getName()});
            }
        }
        if (acc.getClass() == Accessor.GetterSetterReflection.class) {
            Accessor.GetterSetterReflection gacc = (Accessor.GetterSetterReflection)acc;
            if (gacc.getter == null || gacc.setter == null) {
                return null;
            }
            Class<?> t = gacc.getter.getReturnType();
            if (Modifier.isPrivate(gacc.getter.getModifiers()) || Modifier.isPrivate(gacc.setter.getModifiers())) {
                return null;
            }
            if (t.isPrimitive()) {
                opt = AccessorInjector.prepare((Class)dc, (String)(methodTemplateName + suffixMap.get(t)), (String)newClassName, (String[])new String[]{ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(dc), "get_" + t.getName(), gacc.getter.getName(), "set_" + t.getName(), gacc.setter.getName()});
            }
        }
        if (opt == null) {
            return null;
        }
        logger.log(Level.FINE, "Using optimized TransducedAccessor for " + prop.displayName());
        try {
            return (TransducedAccessor)opt.newInstance();
        }
        catch (InstantiationException e) {
            logger.log(Level.INFO, "failed to load an optimized TransducedAccessor", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.INFO, "failed to load an optimized TransducedAccessor", e);
        }
        catch (SecurityException e) {
            logger.log(Level.INFO, "failed to load an optimized TransducedAccessor", e);
        }
        return null;
    }

    static {
        String s = TransducedAccessor_field_Byte.class.getName();
        fieldTemplateName = s.substring(0, s.length() - "Byte".length()).replace('.', '/');
        s = TransducedAccessor_method_Byte.class.getName();
        methodTemplateName = s.substring(0, s.length() - "Byte".length()).replace('.', '/');
        suffixMap = new HashMap<Class, String>();
        suffixMap.put(Byte.TYPE, "Byte");
        suffixMap.put(Short.TYPE, "Short");
        suffixMap.put(Integer.TYPE, "Integer");
        suffixMap.put(Long.TYPE, "Long");
        suffixMap.put(Boolean.TYPE, "Boolean");
        suffixMap.put(Float.TYPE, "Float");
        suffixMap.put(Double.TYPE, "Double");
    }
}

