/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.util.List;
import java.util.Random;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SleepOp
extends Operation {
    private static final Logger LOG = LoggerFactory.getLogger(SleepOp.class);

    SleepOp(ConfigExtractor cfg, Random rnd) {
        super(SleepOp.class.getSimpleName(), cfg, rnd);
    }

    protected long getSleepTime(Range<Long> sleepTime) {
        long sleepMs = Range.betweenPositive(this.getRandom(), sleepTime);
        return sleepMs;
    }

    List<OperationOutput> run(Range<Long> sleepTime) {
        List<OperationOutput> out = super.run(null);
        try {
            if (sleepTime != null) {
                long sleepMs = this.getSleepTime(sleepTime);
                long startTime = Timer.now();
                this.sleep(sleepMs);
                long elapsedTime = Timer.elapsed(startTime);
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", elapsedTime));
                out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", 1L));
            }
        }
        catch (InterruptedException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", 1L));
            LOG.warn("Error with sleeping", (Throwable)e);
        }
        return out;
    }

    @Override
    List<OperationOutput> run(FileSystem fs) {
        Range<Long> sleepTime = this.getConfig().getSleepRange();
        return this.run(sleepTime);
    }

    private void sleep(long ms) throws InterruptedException {
        if (ms <= 0L) {
            return;
        }
        Thread.sleep(ms);
    }
}

