/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver.order;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.RouterResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.net.HostAndPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalResolver
extends RouterResolver<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalResolver.class);

    public LocalResolver(Configuration conf, Router routerService) {
        super(conf, routerService);
    }

    @Override
    protected Map<String, String> getSubclusterInfo(MembershipStore membershipStore) {
        Map<String, String> nnSubcluster;
        HashMap<String, String> mapping = new HashMap<String, String>();
        Map<String, String> dnSubcluster = this.getDatanodesSubcluster();
        if (dnSubcluster != null) {
            mapping.putAll(dnSubcluster);
        }
        if ((nnSubcluster = this.getNamenodesSubcluster(membershipStore)) != null) {
            mapping.putAll(nnSubcluster);
        }
        return mapping;
    }

    @Override
    protected String chooseFirstNamespace(String path, PathLocation loc) {
        String localSubcluster = null;
        String clientAddr = this.getClientAddr();
        Map subclusterInfo = this.getSubclusterMapping();
        if (subclusterInfo != null) {
            localSubcluster = (String)subclusterInfo.get(clientAddr);
            if (localSubcluster != null) {
                LOG.debug("Local namespace for {} is {}", (Object)clientAddr, (Object)localSubcluster);
            } else {
                LOG.error("Cannot get local namespace for {}", (Object)clientAddr);
            }
        } else {
            LOG.error("Cannot get node mapping when resolving {} at {} from {}", new Object[]{path, loc, clientAddr});
        }
        return localSubcluster;
    }

    @VisibleForTesting
    String getClientAddr() {
        return RPC.Server.getRemoteAddress();
    }

    private Map<String, String> getDatanodesSubcluster() {
        final RouterRpcServer rpcServer = this.getRpcServer();
        if (rpcServer == null) {
            LOG.error("Cannot access the Router RPC server");
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        try {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            Map dnMap = (Map)loginUser.doAs((PrivilegedAction)new PrivilegedAction<Map<String, DatanodeStorageReport[]>>(){

                @Override
                public Map<String, DatanodeStorageReport[]> run() {
                    try {
                        return rpcServer.getDatanodeStorageReportMap(HdfsConstants.DatanodeReportType.ALL);
                    }
                    catch (IOException e) {
                        LOG.error("Cannot get the datanodes from the RPC server", (Throwable)e);
                        return null;
                    }
                }
            });
            for (Map.Entry entry : dnMap.entrySet()) {
                DatanodeStorageReport[] dns;
                String nsId = (String)entry.getKey();
                for (DatanodeStorageReport dn : dns = (DatanodeStorageReport[])entry.getValue()) {
                    DatanodeInfo dnInfo = dn.getDatanodeInfo();
                    String ipAddr = dnInfo.getIpAddr();
                    ret.put(ipAddr, nsId);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Cannot get Datanodes from the Namenodes: {}", (Object)e.getMessage());
        }
        return ret;
    }

    private Map<String, String> getNamenodesSubcluster(MembershipStore membershipStore) {
        String localIp;
        String localHostname = localIp = "127.0.0.1";
        try {
            localHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Cannot get local host name");
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        try {
            GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance();
            GetNamenodeRegistrationsResponse response = membershipStore.getNamenodeRegistrations(request);
            List<MembershipState> nns = response.getNamenodeMemberships();
            for (MembershipState nn : nns) {
                try {
                    String nsId = nn.getNameserviceId();
                    String rpcAddress = nn.getRpcAddress();
                    String hostname = HostAndPort.fromString((String)rpcAddress).getHost();
                    ret.put(hostname, nsId);
                    if (hostname.equals(localHostname)) {
                        ret.put(localIp, nsId);
                    }
                    InetAddress addr = InetAddress.getByName(hostname);
                    String ipAddr = addr.getHostAddress();
                    ret.put(ipAddr, nsId);
                }
                catch (Exception e) {
                    LOG.error("Cannot get address for {}: {}", (Object)nn, (Object)e.getMessage());
                }
            }
        }
        catch (IOException ioe) {
            LOG.error("Cannot get Namenodes from the State Store", (Throwable)ioe);
        }
        return ret;
    }
}

