/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.util.concurrent.TimeUnit;
import rx.Observable;

public interface HttpClient<I, O>
extends RxClient<HttpClientRequest<I>, HttpClientResponse<O>> {
    public Observable<HttpClientResponse<O>> submit(HttpClientRequest<I> var1);

    public Observable<HttpClientResponse<O>> submit(HttpClientRequest<I> var1, RxClient.ClientConfig var2);

    public static class HttpClientConfig
    extends RxClient.ClientConfig {
        private String userAgent = "RxNetty Client";
        private RedirectsHandling followRedirect = RedirectsHandling.Undefined;
        private int maxRedirects = 5;
        private long responseSubscriptionTimeoutMs = 1L;

        protected HttpClientConfig() {
        }

        protected HttpClientConfig(RxClient.ClientConfig config) {
            super(config);
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public RedirectsHandling getFollowRedirect() {
            return this.followRedirect;
        }

        public int getMaxRedirects() {
            return this.maxRedirects;
        }

        public long getResponseSubscriptionTimeoutMs() {
            return this.responseSubscriptionTimeoutMs;
        }

        @Override
        public HttpClientConfig clone() throws CloneNotSupportedException {
            return (HttpClientConfig)super.clone();
        }

        public static class Builder
        extends RxClient.ClientConfig.AbstractBuilder<Builder, HttpClientConfig> {
            public Builder(HttpClientConfig defaultConfig) {
                super(null == defaultConfig ? new HttpClientConfig() : defaultConfig);
            }

            public Builder() {
                this(null);
            }

            public Builder userAgent(String userAgent) {
                ((HttpClientConfig)this.config).userAgent = userAgent;
                return (Builder)this.returnBuilder();
            }

            public Builder setFollowRedirect(boolean value) {
                ((HttpClientConfig)this.config).followRedirect = value ? RedirectsHandling.Enable : RedirectsHandling.Disable;
                return (Builder)this.returnBuilder();
            }

            public Builder followRedirect(int maxRedirects) {
                this.setFollowRedirect(true);
                ((HttpClientConfig)this.config).maxRedirects = maxRedirects;
                return (Builder)this.returnBuilder();
            }

            public Builder responseSubscriptionTimeout(long timeout, TimeUnit timeUnit) {
                ((HttpClientConfig)this.config).responseSubscriptionTimeoutMs = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
                return (Builder)this.returnBuilder();
            }

            public static HttpClientConfig newDefaultConfig() {
                return (HttpClientConfig)new Builder().build();
            }

            public static Builder fromDefaultConfig() {
                return Builder.from(Builder.newDefaultConfig());
            }

            public static Builder from(HttpClientConfig source) {
                try {
                    return new Builder(null == source ? Builder.newDefaultConfig() : source.clone());
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public static enum RedirectsHandling {
            Enable,
            Disable,
            Undefined;

        }
    }
}

