/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.FSAclBaseTest;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestAclWithSnapshot {
    private static final UserGroupInformation BRUCE = UserGroupInformation.createUserForTesting((String)"bruce", (String[])new String[0]);
    private static final UserGroupInformation DIANA = UserGroupInformation.createUserForTesting((String)"diana", (String[])new String[0]);
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static FileSystem fsAsBruce;
    private static FileSystem fsAsDiana;
    private static DistributedFileSystem hdfs;
    private static int pathCount;
    private static Path path;
    private static Path snapshotPath;
    private static String snapshotName;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void init() throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        TestAclWithSnapshot.initCluster(true);
    }

    @AfterClass
    public static void shutdown() throws Exception {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{hdfs, fsAsBruce, fsAsDiana});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() {
        path = new Path("/p" + ++pathCount);
        snapshotName = "snapshot" + pathCount;
        snapshotPath = new Path(path, new Path(".snapshot", snapshotName));
    }

    @Test
    public void testOriginalAclEnforcedForSnapshotRootAfterChange() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        hdfs.setAcl(path, (List)aclSpec);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, path);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, path);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        AclStatus s = hdfs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4584, path);
        s = hdfs.getAclStatus(snapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4584, snapshotPath);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, snapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, snapshotPath);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        hdfs.setAcl(path, (List)aclSpec);
        TestAclWithSnapshot.doSnapshotRootChangeAssertions(path, snapshotPath);
        TestAclWithSnapshot.restart(false);
        TestAclWithSnapshot.doSnapshotRootChangeAssertions(path, snapshotPath);
        TestAclWithSnapshot.restart(true);
        TestAclWithSnapshot.doSnapshotRootChangeAssertions(path, snapshotPath);
    }

    private static void doSnapshotRootChangeAssertions(Path path, Path snapshotPath) throws Exception {
        AclStatus s = hdfs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, path);
        s = hdfs.getAclStatus(snapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4584, snapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsBruce, BRUCE, path);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsDiana, DIANA, path);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, snapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, snapshotPath);
    }

    @Test
    public void testOriginalAclEnforcedForSnapshotContentsAfterChange() throws Exception {
        Path filePath = new Path(path, "file1");
        Path subdirPath = new Path(path, "subdir1");
        Path fileSnapshotPath = new Path(snapshotPath, "file1");
        Path subdirSnapshotPath = new Path(snapshotPath, "subdir1");
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)511));
        FileSystem.create((FileSystem)hdfs, (Path)filePath, (FsPermission)FsPermission.createImmutable((short)384)).close();
        FileSystem.mkdirs((FileSystem)hdfs, (Path)subdirPath, (FsPermission)FsPermission.createImmutable((short)448));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        hdfs.setAcl(filePath, (List)aclSpec);
        hdfs.setAcl(subdirPath, (List)aclSpec);
        AclTestHelpers.assertFilePermissionGranted(fsAsBruce, BRUCE, filePath);
        AclTestHelpers.assertFilePermissionDenied(fsAsDiana, DIANA, filePath);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, subdirPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, subdirPath);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)};
        AclStatus s = hdfs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, filePath);
        s = hdfs.getAclStatus(subdirPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, subdirPath);
        s = hdfs.getAclStatus(fileSnapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, fileSnapshotPath);
        AclTestHelpers.assertFilePermissionGranted(fsAsBruce, BRUCE, fileSnapshotPath);
        AclTestHelpers.assertFilePermissionDenied(fsAsDiana, DIANA, fileSnapshotPath);
        s = hdfs.getAclStatus(subdirSnapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, subdirSnapshotPath);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, subdirSnapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, subdirSnapshotPath);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        hdfs.setAcl(filePath, (List)aclSpec);
        hdfs.setAcl(subdirPath, (List)aclSpec);
        TestAclWithSnapshot.doSnapshotContentsChangeAssertions(filePath, fileSnapshotPath, subdirPath, subdirSnapshotPath);
        TestAclWithSnapshot.restart(false);
        TestAclWithSnapshot.doSnapshotContentsChangeAssertions(filePath, fileSnapshotPath, subdirPath, subdirSnapshotPath);
        TestAclWithSnapshot.restart(true);
        TestAclWithSnapshot.doSnapshotContentsChangeAssertions(filePath, fileSnapshotPath, subdirPath, subdirSnapshotPath);
    }

    private static void doSnapshotContentsChangeAssertions(Path filePath, Path fileSnapshotPath, Path subdirPath, Path subdirSnapshotPath) throws Exception {
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)};
        AclStatus s = hdfs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4472, filePath);
        AclTestHelpers.assertFilePermissionDenied(fsAsBruce, BRUCE, filePath);
        AclTestHelpers.assertFilePermissionGranted(fsAsDiana, DIANA, filePath);
        s = hdfs.getAclStatus(subdirPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4472, subdirPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsBruce, BRUCE, subdirPath);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsDiana, DIANA, subdirPath);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)};
        s = hdfs.getAclStatus(fileSnapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, fileSnapshotPath);
        AclTestHelpers.assertFilePermissionGranted(fsAsBruce, BRUCE, fileSnapshotPath);
        AclTestHelpers.assertFilePermissionDenied(fsAsDiana, DIANA, fileSnapshotPath);
        s = hdfs.getAclStatus(subdirSnapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, subdirSnapshotPath);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, subdirSnapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, subdirSnapshotPath);
    }

    @Test
    public void testOriginalAclEnforcedForSnapshotRootAfterRemoval() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        hdfs.setAcl(path, (List)aclSpec);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, path);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, path);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        AclStatus s = hdfs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4584, path);
        s = hdfs.getAclStatus(snapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4584, snapshotPath);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, snapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, snapshotPath);
        hdfs.removeAcl(path);
        TestAclWithSnapshot.doSnapshotRootRemovalAssertions(path, snapshotPath);
        TestAclWithSnapshot.restart(false);
        TestAclWithSnapshot.doSnapshotRootRemovalAssertions(path, snapshotPath);
        TestAclWithSnapshot.restart(true);
        TestAclWithSnapshot.doSnapshotRootRemovalAssertions(path, snapshotPath);
    }

    private static void doSnapshotRootRemovalAssertions(Path path, Path snapshotPath) throws Exception {
        AclStatus s = hdfs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)448, path);
        s = hdfs.getAclStatus(snapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4584, snapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsBruce, BRUCE, path);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, path);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, snapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, snapshotPath);
    }

    @Test
    public void testOriginalAclEnforcedForSnapshotContentsAfterRemoval() throws Exception {
        Path filePath = new Path(path, "file1");
        Path subdirPath = new Path(path, "subdir1");
        Path fileSnapshotPath = new Path(snapshotPath, "file1");
        Path subdirSnapshotPath = new Path(snapshotPath, "subdir1");
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)511));
        FileSystem.create((FileSystem)hdfs, (Path)filePath, (FsPermission)FsPermission.createImmutable((short)384)).close();
        FileSystem.mkdirs((FileSystem)hdfs, (Path)subdirPath, (FsPermission)FsPermission.createImmutable((short)448));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        hdfs.setAcl(filePath, (List)aclSpec);
        hdfs.setAcl(subdirPath, (List)aclSpec);
        AclTestHelpers.assertFilePermissionGranted(fsAsBruce, BRUCE, filePath);
        AclTestHelpers.assertFilePermissionDenied(fsAsDiana, DIANA, filePath);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, subdirPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, subdirPath);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)};
        AclStatus s = hdfs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, filePath);
        s = hdfs.getAclStatus(subdirPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, subdirPath);
        s = hdfs.getAclStatus(fileSnapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, fileSnapshotPath);
        AclTestHelpers.assertFilePermissionGranted(fsAsBruce, BRUCE, fileSnapshotPath);
        AclTestHelpers.assertFilePermissionDenied(fsAsDiana, DIANA, fileSnapshotPath);
        s = hdfs.getAclStatus(subdirSnapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, subdirSnapshotPath);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, subdirSnapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, subdirSnapshotPath);
        hdfs.removeAcl(filePath);
        hdfs.removeAcl(subdirPath);
        TestAclWithSnapshot.doSnapshotContentsRemovalAssertions(filePath, fileSnapshotPath, subdirPath, subdirSnapshotPath);
        TestAclWithSnapshot.restart(false);
        TestAclWithSnapshot.doSnapshotContentsRemovalAssertions(filePath, fileSnapshotPath, subdirPath, subdirSnapshotPath);
        TestAclWithSnapshot.restart(true);
        TestAclWithSnapshot.doSnapshotContentsRemovalAssertions(filePath, fileSnapshotPath, subdirPath, subdirSnapshotPath);
    }

    private static void doSnapshotContentsRemovalAssertions(Path filePath, Path fileSnapshotPath, Path subdirPath, Path subdirSnapshotPath) throws Exception {
        Object[] expected = new AclEntry[]{};
        AclStatus s = hdfs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)320, filePath);
        AclTestHelpers.assertFilePermissionDenied(fsAsBruce, BRUCE, filePath);
        AclTestHelpers.assertFilePermissionDenied(fsAsDiana, DIANA, filePath);
        s = hdfs.getAclStatus(subdirPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)320, subdirPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsBruce, BRUCE, subdirPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, subdirPath);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)};
        s = hdfs.getAclStatus(fileSnapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, fileSnapshotPath);
        AclTestHelpers.assertFilePermissionGranted(fsAsBruce, BRUCE, fileSnapshotPath);
        AclTestHelpers.assertFilePermissionDenied(fsAsDiana, DIANA, fileSnapshotPath);
        s = hdfs.getAclStatus(subdirSnapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4456, subdirSnapshotPath);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, subdirSnapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, subdirSnapshotPath);
    }

    @Test
    public void testModifyReadsCurrentState() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL)});
        hdfs.modifyAclEntries(path, (List)aclSpec);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_EXECUTE)});
        hdfs.modifyAclEntries(path, (List)aclSpec);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "diana", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)};
        AclStatus s = hdfs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4600, path);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsBruce, BRUCE, path);
        TestAclWithSnapshot.assertDirPermissionGranted(fsAsDiana, DIANA, path);
    }

    @Test
    public void testRemoveReadsCurrentState() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.ALL)});
        hdfs.modifyAclEntries(path, (List)aclSpec);
        hdfs.removeAcl(path);
        Object[] expected = new AclEntry[]{};
        AclStatus s = hdfs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)448, path);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsBruce, BRUCE, path);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsDiana, DIANA, path);
    }

    @Test
    public void testDefaultAclNotCopiedToAccessAclOfNewSnapshot() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE)});
        hdfs.modifyAclEntries(path, (List)aclSpec);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        AclStatus s = hdfs.getAclStatus(path);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4544, path);
        s = hdfs.getAclStatus(snapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.NONE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ_EXECUTE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4544, snapshotPath);
        TestAclWithSnapshot.assertDirPermissionDenied(fsAsBruce, BRUCE, snapshotPath);
    }

    @Test
    public void testModifyAclEntriesSnapshotPath() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce", FsAction.READ_EXECUTE)});
        this.exception.expect(SnapshotAccessControlException.class);
        hdfs.modifyAclEntries(snapshotPath, (List)aclSpec);
    }

    @Test
    public void testRemoveAclEntriesSnapshotPath() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce")});
        this.exception.expect(SnapshotAccessControlException.class);
        hdfs.removeAclEntries(snapshotPath, (List)aclSpec);
    }

    @Test
    public void testRemoveDefaultAclSnapshotPath() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        this.exception.expect(SnapshotAccessControlException.class);
        hdfs.removeDefaultAcl(snapshotPath);
    }

    @Test
    public void testRemoveAclSnapshotPath() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        this.exception.expect(SnapshotAccessControlException.class);
        hdfs.removeAcl(snapshotPath);
    }

    @Test
    public void testSetAclSnapshotPath() throws Exception {
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)448));
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "bruce")});
        this.exception.expect(SnapshotAccessControlException.class);
        hdfs.setAcl(snapshotPath, (List)aclSpec);
    }

    @Test
    public void testChangeAclExceedsQuota() throws Exception {
        Path filePath = new Path(path, "file1");
        Path fileSnapshotPath = new Path(snapshotPath, "file1");
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)493));
        hdfs.allowSnapshot(path);
        hdfs.setQuota(path, 3L, Long.MAX_VALUE);
        FileSystem.create((FileSystem)hdfs, (Path)filePath, (FsPermission)FsPermission.createImmutable((short)384)).close();
        hdfs.setPermission(filePath, FsPermission.createImmutable((short)384));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE)});
        hdfs.modifyAclEntries(filePath, (List)aclSpec);
        hdfs.createSnapshot(path, snapshotName);
        AclStatus s = hdfs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4528, filePath);
        s = hdfs.getAclStatus(fileSnapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4528, filePath);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)});
        hdfs.modifyAclEntries(filePath, (List)aclSpec);
    }

    @Test
    public void testRemoveAclExceedsQuota() throws Exception {
        Path filePath = new Path(path, "file1");
        Path fileSnapshotPath = new Path(snapshotPath, "file1");
        FileSystem.mkdirs((FileSystem)hdfs, (Path)path, (FsPermission)FsPermission.createImmutable((short)493));
        hdfs.allowSnapshot(path);
        hdfs.setQuota(path, 3L, Long.MAX_VALUE);
        FileSystem.create((FileSystem)hdfs, (Path)filePath, (FsPermission)FsPermission.createImmutable((short)384)).close();
        hdfs.setPermission(filePath, FsPermission.createImmutable((short)384));
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE)});
        hdfs.modifyAclEntries(filePath, (List)aclSpec);
        hdfs.createSnapshot(path, snapshotName);
        AclStatus s = hdfs.getAclStatus(filePath);
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4528, filePath);
        s = hdfs.getAclStatus(fileSnapshotPath);
        returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.NONE)}, (Object[])returned);
        TestAclWithSnapshot.assertPermission((short)4528, filePath);
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bruce", FsAction.READ)});
        hdfs.removeAcl(filePath);
    }

    @Test
    public void testGetAclStatusDotSnapshotPath() throws Exception {
        hdfs.mkdirs(path);
        SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        AclStatus s = hdfs.getAclStatus(new Path(path, ".snapshot"));
        Object[] returned = s.getEntries().toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])new AclEntry[0], (Object[])returned);
    }

    @Test
    public void testDeDuplication() throws Exception {
        int startSize = AclStorage.getUniqueAclFeatures().getUniqueElementsSize();
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "testdeduplicateuser", FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, "testdeduplicategroup", FsAction.ALL)});
        hdfs.mkdirs(path);
        hdfs.modifyAclEntries(path, (List)aclSpec);
        Assert.assertEquals((String)"One more ACL feature should be unique", (long)(startSize + 1), (long)AclStorage.getUniqueAclFeatures().getUniqueElementsSize());
        Path subdir = new Path(path, "sub-dir");
        hdfs.mkdirs(subdir);
        Path file = new Path(path, "file");
        hdfs.create(file).close();
        AclFeature aclFeature = FSAclBaseTest.getAclFeature(path, cluster);
        Assert.assertEquals((String)"Reference count should be one before snapshot", (long)1L, (long)aclFeature.getRefCount());
        Path snapshotPath = SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        AclFeature snapshotAclFeature = FSAclBaseTest.getAclFeature(snapshotPath, cluster);
        Assert.assertSame((Object)aclFeature, (Object)snapshotAclFeature);
        Assert.assertEquals((String)"Reference count should be increased", (long)2L, (long)snapshotAclFeature.getRefCount());
        this.deleteSnapshotWithAclAndVerify(aclFeature, path, startSize);
        hdfs.modifyAclEntries(subdir, (List)aclSpec);
        aclFeature = FSAclBaseTest.getAclFeature(subdir, cluster);
        Assert.assertEquals((String)"Reference count should be 1", (long)1L, (long)aclFeature.getRefCount());
        snapshotPath = SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Path subdirInSnapshot = new Path(snapshotPath, "sub-dir");
        AclFeature snapshotAcl = FSAclBaseTest.getAclFeature(subdirInSnapshot, cluster);
        Assert.assertSame((Object)aclFeature, (Object)snapshotAcl);
        Assert.assertEquals((String)"Reference count should remain same", (long)1L, (long)aclFeature.getRefCount());
        this.deleteSnapshotWithAclAndVerify(aclFeature, subdir, startSize);
        hdfs.modifyAclEntries(file, (List)aclSpec);
        aclFeature = FSAclBaseTest.getAclFeature(file, cluster);
        Assert.assertEquals((String)"Reference count should be 1", (long)1L, (long)aclFeature.getRefCount());
        snapshotPath = SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Path fileInSnapshot = new Path(snapshotPath, file.getName());
        snapshotAcl = FSAclBaseTest.getAclFeature(fileInSnapshot, cluster);
        Assert.assertSame((Object)aclFeature, (Object)snapshotAcl);
        Assert.assertEquals((String)"Reference count should remain same", (long)1L, (long)aclFeature.getRefCount());
        this.deleteSnapshotWithAclAndVerify(aclFeature, file, startSize);
        hdfs.modifyAclEntries(path, (List)aclSpec);
        snapshotPath = SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        AclFeature snapshotAcl2 = FSAclBaseTest.getAclFeature(snapshotPath, cluster);
        aclFeature = FSAclBaseTest.getAclFeature(path, cluster);
        Assert.assertEquals((String)"Before modification same ACL should be referenced twice", (long)2L, (long)aclFeature.getRefCount());
        ArrayList newAcl = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "testNewUser", FsAction.ALL)});
        hdfs.modifyAclEntries(path, (List)newAcl);
        aclFeature = FSAclBaseTest.getAclFeature(path, cluster);
        AclFeature snapshotAclPostModification = FSAclBaseTest.getAclFeature(snapshotPath, cluster);
        Assert.assertSame((Object)snapshotAcl2, (Object)snapshotAclPostModification);
        Assert.assertNotSame((Object)aclFeature, (Object)snapshotAclPostModification);
        Assert.assertEquals((String)"Old ACL feature reference count should be same", (long)1L, (long)snapshotAcl2.getRefCount());
        Assert.assertEquals((String)"New ACL feature reference should be used", (long)1L, (long)aclFeature.getRefCount());
        this.deleteSnapshotWithAclAndVerify(aclFeature, path, startSize);
        hdfs.modifyAclEntries(subdir, (List)aclSpec);
        snapshotPath = SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        subdirInSnapshot = new Path(snapshotPath, "sub-dir");
        AclFeature snapshotAclFeature2 = FSAclBaseTest.getAclFeature(subdirInSnapshot, cluster);
        ArrayList newAcl2 = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "testNewUser", FsAction.ALL)});
        hdfs.modifyAclEntries(subdir, (List)newAcl2);
        aclFeature = FSAclBaseTest.getAclFeature(subdir, cluster);
        Assert.assertNotSame((Object)aclFeature, (Object)snapshotAclFeature2);
        Assert.assertEquals((String)"Reference count should remain same", (long)1L, (long)snapshotAclFeature2.getRefCount());
        Assert.assertEquals((String)"New AclFeature should be used", (long)1L, (long)aclFeature.getRefCount());
        this.deleteSnapshotWithAclAndVerify(aclFeature, subdir, startSize);
        hdfs.modifyAclEntries(file, (List)aclSpec);
        snapshotPath = SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        fileInSnapshot = new Path(snapshotPath, file.getName());
        snapshotAclFeature2 = FSAclBaseTest.getAclFeature(fileInSnapshot, cluster);
        newAcl2 = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "testNewUser", FsAction.ALL)});
        hdfs.modifyAclEntries(file, (List)newAcl2);
        aclFeature = FSAclBaseTest.getAclFeature(file, cluster);
        Assert.assertNotSame((Object)aclFeature, (Object)snapshotAclFeature2);
        Assert.assertEquals((String)"Reference count should remain same", (long)1L, (long)snapshotAclFeature2.getRefCount());
        this.deleteSnapshotWithAclAndVerify(aclFeature, file, startSize);
        hdfs.delete(path, true);
        Path dir = new Path(subdir, "dir");
        hdfs.mkdirs(dir);
        hdfs.modifyAclEntries(dir, (List)aclSpec);
        file = new Path(subdir, "file");
        hdfs.create(file).close();
        aclSpec.add(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "testNewUser", FsAction.ALL));
        hdfs.modifyAclEntries(file, (List)aclSpec);
        AclFeature fileAcl = FSAclBaseTest.getAclFeature(file, cluster);
        AclFeature dirAcl = FSAclBaseTest.getAclFeature(dir, cluster);
        Path snapshotPath2 = SnapshotTestHelper.createSnapshot(hdfs, path, snapshotName);
        Path dirInSnapshot = new Path(snapshotPath2, "sub-dir/dir");
        AclFeature snapshotDirAclFeature = FSAclBaseTest.getAclFeature(dirInSnapshot, cluster);
        Path fileInSnapshot2 = new Path(snapshotPath2, "sub-dir/file");
        AclFeature snapshotFileAclFeature = FSAclBaseTest.getAclFeature(fileInSnapshot2, cluster);
        Assert.assertSame((Object)fileAcl, (Object)snapshotFileAclFeature);
        Assert.assertSame((Object)dirAcl, (Object)snapshotDirAclFeature);
        hdfs.delete(subdir, true);
        Assert.assertEquals((String)"Original ACLs references should be maintained for snapshot", (long)1L, (long)snapshotFileAclFeature.getRefCount());
        Assert.assertEquals((String)"Original ACLs references should be maintained for snapshot", (long)1L, (long)snapshotDirAclFeature.getRefCount());
        hdfs.deleteSnapshot(path, snapshotName);
        Assert.assertEquals((String)"ACLs should be deleted from snapshot", (long)startSize, (long)AclStorage.getUniqueAclFeatures().getUniqueElementsSize());
    }

    private void deleteSnapshotWithAclAndVerify(AclFeature aclFeature, Path pathToCheckAcl, int totalAclFeatures) throws IOException {
        hdfs.deleteSnapshot(path, snapshotName);
        AclFeature afterDeleteAclFeature = FSAclBaseTest.getAclFeature(pathToCheckAcl, cluster);
        Assert.assertSame((Object)aclFeature, (Object)afterDeleteAclFeature);
        Assert.assertEquals((String)"Reference count should remain same even after deletion of snapshot", (long)1L, (long)afterDeleteAclFeature.getRefCount());
        hdfs.removeAcl(pathToCheckAcl);
        Assert.assertEquals((String)"Reference count should be 0", (long)0L, (long)aclFeature.getRefCount());
        Assert.assertEquals((String)"Unique ACL features should remain same", (long)totalAclFeatures, (long)AclStorage.getUniqueAclFeatures().getUniqueElementsSize());
    }

    private static void assertDirPermissionDenied(FileSystem fs, UserGroupInformation user, Path pathToCheck) throws Exception {
        try {
            fs.listStatus(pathToCheck);
            Assert.fail((String)("expected AccessControlException for user " + user + ", path = " + pathToCheck));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            fs.access(pathToCheck, FsAction.READ);
            Assert.fail((String)("The access call should have failed for " + pathToCheck));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private static void assertDirPermissionGranted(FileSystem fs, UserGroupInformation user, Path pathToCheck) throws Exception {
        try {
            fs.listStatus(pathToCheck);
            fs.access(pathToCheck, FsAction.READ);
        }
        catch (AccessControlException e) {
            Assert.fail((String)("expected permission granted for user " + user + ", path = " + pathToCheck));
        }
    }

    private static void assertPermission(short perm, Path pathToCheck) throws Exception {
        AclTestHelpers.assertPermission((FileSystem)hdfs, pathToCheck, perm);
    }

    private static void initCluster(boolean format) throws Exception {
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
        fsAsBruce = DFSTestUtil.getFileSystemAs(BRUCE, conf);
        fsAsDiana = DFSTestUtil.getFileSystemAs(DIANA, conf);
    }

    private static void restart(boolean checkpoint) throws Exception {
        NameNode nameNode = cluster.getNameNode();
        if (checkpoint) {
            NameNodeAdapter.enterSafeMode(nameNode, false);
            NameNodeAdapter.saveNamespace(nameNode);
        }
        TestAclWithSnapshot.shutdown();
        TestAclWithSnapshot.initCluster(false);
    }

    static {
        pathCount = 0;
    }
}

