/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BaseReplicationPolicyTest;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.net.Node;
import org.junit.Assert;
import org.junit.Test;

public class TestReplicationPolicyRatioConsiderLoadWithStorage
extends BaseReplicationPolicyTest {
    public TestReplicationPolicyRatioConsiderLoadWithStorage() {
        this.blockPlacementPolicy = BlockPlacementPolicyDefault.class.getName();
    }

    @Override
    DatanodeDescriptor[] getDatanodeDescriptors(Configuration conf) {
        conf.setBoolean("dfs.namenode.redundancy.considerLoad", true);
        conf.setDouble("dfs.namenode.redundancy.considerLoad.factor", 2.0);
        conf.setBoolean("dfs.namenode.redundancy.considerLoadByVolume", true);
        String[] racks = new String[]{"/rack1", "/rack2", "/rack3", "/rack4", "/rack5"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        DatanodeDescriptor[] descriptors = DFSTestUtil.toDatanodeDescriptor(this.storages);
        long storageCapacity = 2048L;
        for (int i = 0; i < descriptors.length; ++i) {
            int j;
            for (j = 0; j < 5; ++j) {
                DatanodeStorage s = new DatanodeStorage("s" + i + j);
                descriptors[i].updateStorage(s);
            }
            for (j = 0; j < descriptors[i].getStorageInfos().length; ++j) {
                DatanodeStorageInfo dsInfo = descriptors[i].getStorageInfos()[j];
                if (j > i + 1) {
                    dsInfo.setUtilizationForTesting(storageCapacity, storageCapacity, 0L, storageCapacity);
                    continue;
                }
                dsInfo.setUtilizationForTesting(storageCapacity, 0L, storageCapacity, 0L);
            }
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTargetWithRatioConsiderLoad() {
        this.namenode.getNamesystem().writeLock();
        try {
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[0], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[0]), this.dataNodes[0].getCacheCapacity(), this.dataNodes[0].getCacheUsed(), 50, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[1], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[1]), this.dataNodes[0].getCacheCapacity(), this.dataNodes[0].getCacheUsed(), 110, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[2], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[2]), this.dataNodes[0].getCacheCapacity(), this.dataNodes[0].getCacheUsed(), 28, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[3], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[3]), this.dataNodes[0].getCacheCapacity(), this.dataNodes[0].getCacheUsed(), 2, 0, null);
            this.dnManager.getHeartbeatManager().updateHeartbeat(this.dataNodes[4], BlockManagerTestUtil.getStorageReportsForDatanode(this.dataNodes[4]), this.dataNodes[0].getCacheCapacity(), this.dataNodes[0].getCacheUsed(), 10, 0, null);
            HashSet<DatanodeDescriptor> targetSet = new HashSet<DatanodeDescriptor>();
            DatanodeDescriptor writerDn = this.dataNodes[2];
            DatanodeStorageInfo[] targets = this.namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget("testFile.txt", 3, (Node)writerDn, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assert.assertEquals((long)3L, (long)targets.length);
            for (DatanodeStorageInfo dsi : targets) {
                targetSet.add(dsi.getDatanodeDescriptor());
            }
            Assert.assertTrue((boolean)targetSet.contains(this.dataNodes[2]));
            Assert.assertTrue((boolean)targetSet.contains(this.dataNodes[3]));
            Assert.assertTrue((boolean)targetSet.contains(this.dataNodes[4]));
            targets = this.namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget("testFile.txt", 4, (Node)writerDn, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assert.assertEquals((long)3L, (long)targets.length);
            targetSet.clear();
            for (DatanodeStorageInfo dsi : targets) {
                targetSet.add(dsi.getDatanodeDescriptor());
            }
            Assert.assertTrue((boolean)targetSet.contains(this.dataNodes[2]));
            Assert.assertTrue((boolean)targetSet.contains(this.dataNodes[3]));
            Assert.assertTrue((boolean)targetSet.contains(this.dataNodes[4]));
        }
        finally {
            this.namenode.getNamesystem().writeUnlock();
        }
    }
}

