/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.rbfbalance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.rbfbalance.MountTableProcedure;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.impl.MountTableStoreImpl;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.AddMountTableEntryResponse;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMountTableProcedure {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static Configuration routerConf;
    private static List<MountTable> mockMountTable;
    private static StateStoreService stateStore;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 1);
        Configuration conf = new RouterConfigBuilder().stateStore().admin().rpc().build();
        cluster.addRouterOverrides(conf);
        cluster.startRouters();
        routerContext = cluster.getRandomRouter();
        mockMountTable = cluster.generateMockMountTable();
        Router router = routerContext.getRouter();
        stateStore = router.getStateStore();
        ActiveNamenodeResolver membership = router.getNamenodeResolver();
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns0", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        membership.registerNamenode(FederationTestUtils.createNamenodeReport("ns1", "nn1", HAServiceProtocol.HAServiceState.ACTIVE));
        stateStore.refreshCaches(true);
        routerConf = new Configuration();
        InetSocketAddress routerSocket = router.getAdminServerAddress();
        routerConf.setSocketAddr("dfs.federation.router.admin-address", routerSocket);
    }

    @AfterClass
    public static void tearDown() {
        cluster.stopRouter(routerContext);
    }

    @Before
    public void testSetup() throws Exception {
        Assert.assertTrue((boolean)FederationStateStoreTestUtils.synchronizeRecords(stateStore, mockMountTable, MountTable.class));
        routerContext.resetAdminClient();
    }

    @Test
    public void testUpdateMountpoint() throws Exception {
        String mount = "/test-path";
        String dst = "/test-dst";
        MountTable newEntry = MountTable.newInstance((String)mount, Collections.singletonMap("ns0", mount), (long)Time.now(), (long)Time.now());
        MountTableManager mountTable = routerContext.getAdminClient().getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
        GetMountTableEntriesRequest request = GetMountTableEntriesRequest.newInstance((String)"/");
        stateStore.loadCache(MountTableStoreImpl.class, true);
        GetMountTableEntriesResponse response = mountTable.getMountTableEntries(request);
        Assert.assertEquals((long)3L, (long)response.getEntries().size());
        MountTableProcedure.disableWrite((String)mount, (Configuration)routerConf);
        String dstNs = "ns1";
        MountTableProcedure smtp = new MountTableProcedure("single-mount-table-procedure", null, 1000L, mount, dst, dstNs, routerConf);
        Assert.assertTrue((boolean)smtp.execute());
        stateStore.loadCache(MountTableStoreImpl.class, true);
        MountTable entry = MountTableProcedure.getMountEntry((String)mount, (MountTableManager)mountTable);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)1L, (long)entry.getDestinations().size());
        String nsId = ((RemoteLocation)entry.getDestinations().get(0)).getNameserviceId();
        String dstPath = ((RemoteLocation)entry.getDestinations().get(0)).getDest();
        Assert.assertEquals((Object)dstNs, (Object)nsId);
        Assert.assertEquals((Object)dst, (Object)dstPath);
        URI address = routerContext.getFileSystemURI();
        DFSClient routerClient = new DFSClient(address, routerConf);
        MountTableProcedure.enableWrite((String)mount, (Configuration)routerConf);
        LambdaTestUtils.intercept(RemoteException.class, (String)"No namenode available to invoke mkdirs", (String)"Expect no namenode exception.", () -> routerClient.mkdirs(mount + "/file", new FsPermission(16), false));
    }

    @Test
    public void testDisableAndEnableWrite() throws Exception {
        String mount = "/test-write";
        MountTable newEntry = MountTable.newInstance((String)mount, Collections.singletonMap("ns0", mount), (long)Time.now(), (long)Time.now());
        MountTableManager mountTable = routerContext.getAdminClient().getMountTableManager();
        AddMountTableEntryRequest addRequest = AddMountTableEntryRequest.newInstance((MountTable)newEntry);
        AddMountTableEntryResponse addResponse = mountTable.addMountTableEntry(addRequest);
        Assert.assertTrue((boolean)addResponse.getStatus());
        stateStore.loadCache(MountTableStoreImpl.class, true);
        URI address = routerContext.getFileSystemURI();
        DFSClient routerClient = new DFSClient(address, routerConf);
        LambdaTestUtils.intercept(RemoteException.class, (String)"No namenode available to invoke mkdirs", (String)"Expect no namenode exception.", () -> routerClient.mkdirs(mount + "/file", new FsPermission(16), false));
        MountTableProcedure.disableWrite((String)mount, (Configuration)routerConf);
        LambdaTestUtils.intercept(RemoteException.class, (String)"is in a read only mount point", (String)"Expect readonly exception.", () -> routerClient.mkdirs(mount + "/dir", new FsPermission(16), false));
        MountTableProcedure.enableWrite((String)mount, (Configuration)routerConf);
        LambdaTestUtils.intercept(RemoteException.class, (String)"No namenode available to invoke mkdirs", (String)"Expect no namenode exception.", () -> routerClient.mkdirs(mount + "/file", new FsPermission(16), false));
    }

    @Test
    public void testSeDeserialize() throws Exception {
        String fedPath = "/test-path";
        String dst = "/test-dst";
        String dstNs = "ns1";
        MountTableProcedure smtp = new MountTableProcedure("single-mount-table-procedure", null, 1000L, fedPath, dst, dstNs, routerConf);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bao);
        smtp.write((DataOutput)dataOut);
        smtp = new MountTableProcedure();
        smtp.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bao.toByteArray())));
        Assert.assertEquals((Object)fedPath, (Object)smtp.getMount());
        Assert.assertEquals((Object)dst, (Object)smtp.getDstPath());
        Assert.assertEquals((Object)dstNs, (Object)smtp.getDstNs());
    }
}

