/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.applications.mawo.server.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.applications.mawo.server.master.job.JobId;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class TaskId
implements Writable {
    static final String TASK_ID_PREFIX = "mawo_task_";
    private JobId jobId = new JobId();
    private long taskId;

    public TaskId() {
    }

    public TaskId(JobId localjobId, int id) {
        this.jobId = localjobId;
        this.taskId = id;
    }

    public final int getJobId() {
        return this.jobId.getID();
    }

    public final long getId() {
        return this.taskId;
    }

    public final String toString() {
        return TASK_ID_PREFIX + this.jobId.getID() + "_" + this.taskId;
    }

    public final int hashCode() {
        int prime = 31;
        int bits = 32;
        int result = 1;
        int jobHash = 0;
        jobHash = this.jobId == null ? 0 : this.jobId.hashCode();
        result = 31 * result + jobHash;
        result = 31 * result + (int)(this.taskId ^ this.taskId >>> 32);
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskId other = (TaskId)obj;
        if (this.jobId == null ? other.jobId != null : !this.jobId.equals(other.jobId)) {
            return false;
        }
        return this.taskId == other.taskId;
    }

    public final void write(DataOutput out) throws IOException {
        this.jobId.write(out);
        WritableUtils.writeVLong((DataOutput)out, (long)this.taskId);
    }

    public final void readFields(DataInput in) throws IOException {
        this.jobId = new JobId();
        this.jobId.readFields(in);
        this.taskId = WritableUtils.readVLong((DataInput)in);
    }
}

