/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.workloadgenerator.audit;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class UserCommandKey
implements WritableComparable {
    private Text user;
    private Text command;
    private Text type;

    public UserCommandKey() {
        this.user = new Text();
        this.command = new Text();
        this.type = new Text();
    }

    public UserCommandKey(Text user, Text command, Text type) {
        this.user = user;
        this.command = command;
        this.type = type;
    }

    public UserCommandKey(String user, String command, String type) {
        this.user = new Text(user);
        this.command = new Text(command);
        this.type = new Text(type);
    }

    public String getUser() {
        return this.user.toString();
    }

    public String getCommand() {
        return this.command.toString();
    }

    public String getType() {
        return this.type.toString();
    }

    public void write(DataOutput out) throws IOException {
        this.user.write(out);
        this.command.write(out);
        this.type.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.user.readFields(in);
        this.command.readFields(in);
        this.type.readFields(in);
    }

    public int compareTo(@Nonnull Object o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return this.getUser() + "," + this.getType() + "," + this.getCommand();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCommandKey that = (UserCommandKey)o;
        return this.getUser().equals(that.getUser()) && this.getCommand().equals(that.getCommand()) && this.getType().equals(that.getType());
    }

    public int hashCode() {
        return Objects.hash(this.getUser(), this.getCommand(), this.getType());
    }
}

