/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalBasicArray;
import org.ojalgo.matrix.decomposition.TridiagonalDecomposition;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.scalar.ComplexNumber;

abstract class DeferredTridiagonal<N extends Number>
extends TridiagonalDecomposition<N> {
    private transient BasicArray<N> myDiagD = null;
    private transient BasicArray<N> myDiagE = null;
    private Array1D<N> myInitDiagQ = null;

    protected DeferredTridiagonal(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        super(factory);
    }

    @Override
    public final boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        this.reset();
        boolean retVal = false;
        try {
            MatrixStore.LogicalBuilder<N> logicallyTriangularMatrix = this.collect(matrix).logical().triangular(false, false);
            DecompositionStore inPlace = this.setInPlace(logicallyTriangularMatrix);
            int size = this.getMinDim();
            if (this.myDiagD == null || this.myDiagD.count() != (long)size) {
                this.myDiagD = this.makeArray(size);
                this.myDiagE = this.makeArray(size);
            }
            Householder tmpHouseholder = this.makeHouseholder(size);
            int limit = size - 2;
            for (int ij = 0; ij < limit; ++ij) {
                if (!inPlace.generateApplyAndCopyHouseholderColumn(ij + 1, ij, tmpHouseholder)) continue;
                inPlace.transformSymmetric(tmpHouseholder);
            }
            this.myDiagD.fillMatching(inPlace.sliceDiagonal(0L, 0L));
            this.myDiagE.fillMatching(inPlace.sliceDiagonal(1L, 0L));
            this.myInitDiagQ = this.makeReal(this.myDiagE);
            retVal = true;
        }
        catch (Exception xcptn) {
            BasicLogger.error(xcptn.toString());
            this.reset();
            retVal = false;
        }
        return this.computed(retVal);
    }

    @Override
    public void reset() {
        super.reset();
        this.myInitDiagQ = null;
    }

    @Override
    protected void supplyDiagonalTo(double[] d, double[] e) {
        this.myDiagD.supplyTo(d);
        this.myDiagE.supplyTo(e);
    }

    @Override
    final MatrixStore<N> makeD() {
        return this.wrap(new DiagonalBasicArray<N>(this.myDiagD, this.myDiagE, this.myDiagE, this.scalar().zero().getNumber())).get();
    }

    @Override
    final DecompositionStore<N> makeQ() {
        DecompositionStore retVal = this.getInPlace();
        int tmpDim = this.getMinDim();
        HouseholderReference tmpReference = HouseholderReference.makeColumn(retVal);
        if (this.myInitDiagQ != null) {
            retVal.set((long)(tmpDim - 1), (long)(tmpDim - 1), (Number)this.myInitDiagQ.get(tmpDim - 1));
            if (tmpDim >= 2) {
                retVal.set((long)(tmpDim - 2), (long)(tmpDim - 2), (Number)this.myInitDiagQ.get(tmpDim - 2));
            }
        } else {
            retVal.set((long)(tmpDim - 1), (long)(tmpDim - 1), PrimitiveMath.ONE);
            if (tmpDim >= 2) {
                retVal.set((long)(tmpDim - 2), (long)(tmpDim - 2), PrimitiveMath.ONE);
            }
        }
        if (tmpDim >= 2) {
            retVal.set((long)(tmpDim - 1), (long)(tmpDim - 2), PrimitiveMath.ZERO);
        }
        for (int ij = tmpDim - 3; ij >= 0; --ij) {
            tmpReference.point(ij + 1, ij);
            if (!tmpReference.isZero()) {
                retVal.transformLeft(tmpReference, ij);
            }
            retVal.setToIdentity(ij);
            if (this.myInitDiagQ == null) continue;
            retVal.set((long)ij, (long)ij, (Number)this.myInitDiagQ.get(ij));
        }
        return retVal;
    }

    abstract Array1D<N> makeReal(BasicArray<N> var1);

    static final class Primitive
    extends DeferredTridiagonal<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }

        @Override
        Array1D<Double> makeReal(BasicArray<Double> offDiagonal) {
            return null;
        }
    }

    static final class Complex
    extends DeferredTridiagonal<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY);
        }

        @Override
        Array1D<ComplexNumber> makeReal(BasicArray<ComplexNumber> offDiagonal) {
            Structure1D retVal = Array1D.COMPLEX.makeZero(offDiagonal.count());
            ((Array1D)retVal).fillAll(ComplexNumber.ONE);
            BasicArray<ComplexNumber> tmpSubdiagonal = offDiagonal;
            ComplexNumber tmpVal = null;
            int i = 0;
            while ((long)i < tmpSubdiagonal.count()) {
                tmpVal = ((ComplexNumber)tmpSubdiagonal.get(i)).signum();
                if (!tmpVal.isReal()) {
                    tmpSubdiagonal.set((long)i, ((ComplexNumber)tmpSubdiagonal.get(i)).divide(tmpVal));
                    if ((long)(i + 1) < tmpSubdiagonal.count()) {
                        tmpSubdiagonal.set((long)(i + 1), ((ComplexNumber)tmpSubdiagonal.get(i + 1)).multiply(tmpVal));
                    }
                    ((Array1D)retVal).set(i + 1, (Object)tmpVal);
                }
                ++i;
            }
            return retVal;
        }
    }

    static final class Big
    extends DeferredTridiagonal<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY);
        }

        @Override
        Array1D<BigDecimal> makeReal(BasicArray<BigDecimal> offDiagonal) {
            return null;
        }
    }
}

