/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.gridmix.DistributedCacheEmulator;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.LoadJob;
import org.apache.hadoop.mapred.gridmix.SleepJob;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public enum JobCreator {
    LOADJOB{

        @Override
        public GridmixJob createGridmixJob(Configuration gridmixConf, long submissionMillis, JobStory jobdesc, Path outRoot, UserGroupInformation ugi, int seq) throws IOException {
            Configuration conf = new Configuration(gridmixConf);
            this.dce.configureDistCacheFiles(conf, jobdesc.getJobConf());
            return new LoadJob(conf, submissionMillis, jobdesc, outRoot, ugi, seq);
        }

        @Override
        public boolean canEmulateDistCacheLoad() {
            return true;
        }
    }
    ,
    SLEEPJOB{
        private String[] hosts;

        @Override
        public GridmixJob createGridmixJob(Configuration conf, long submissionMillis, JobStory jobdesc, Path outRoot, UserGroupInformation ugi, int seq) throws IOException {
            int numLocations = conf.getInt(JobCreator.SLEEPJOB_RANDOM_LOCATIONS, 0);
            if (numLocations < 0) {
                numLocations = 0;
            }
            if (this.hosts == null) {
                JobClient client = new JobClient(new JobConf(conf));
                ClusterStatus stat = client.getClusterStatus(true);
                int nTrackers = stat.getTaskTrackers();
                ArrayList<String> hostList = new ArrayList<String>(nTrackers);
                Pattern trackerPattern = Pattern.compile("tracker_([^:]*):.*");
                Matcher m = trackerPattern.matcher("");
                for (String tracker : stat.getActiveTrackerNames()) {
                    m.reset(tracker);
                    if (!m.find()) continue;
                    String name = m.group(1);
                    hostList.add(name);
                }
                this.hosts = hostList.toArray(new String[hostList.size()]);
            }
            return new SleepJob(conf, submissionMillis, jobdesc, outRoot, ugi, seq, numLocations, this.hosts);
        }

        @Override
        public boolean canEmulateDistCacheLoad() {
            return false;
        }
    };

    public static final String GRIDMIX_JOB_TYPE = "gridmix.job.type";
    public static final String SLEEPJOB_RANDOM_LOCATIONS = "gridmix.sleep.fake-locations";
    DistributedCacheEmulator dce;

    public abstract GridmixJob createGridmixJob(Configuration var1, long var2, JobStory var4, Path var5, UserGroupInformation var6, int var7) throws IOException;

    public static JobCreator getPolicy(Configuration conf, JobCreator defaultPolicy) {
        return (JobCreator)conf.getEnum(GRIDMIX_JOB_TYPE, (Enum)defaultPolicy);
    }

    abstract boolean canEmulateDistCacheLoad();

    void setDistCacheEmulator(DistributedCacheEmulator e) {
        this.dce = e;
    }
}

