/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss.statistics.impl;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.aliyun.oss.statistics.BlockOutputStreamStatistics;

public class OutputStreamStatistics
implements BlockOutputStreamStatistics {
    private final AtomicInteger blocksAllocated = new AtomicInteger(0);
    private final AtomicInteger blocksReleased = new AtomicInteger(0);
    private final AtomicInteger diskBlocksAllocated = new AtomicInteger(0);
    private final AtomicInteger diskBlocksReleased = new AtomicInteger(0);
    private final AtomicLong bytesAllocated = new AtomicLong(0L);
    private final AtomicLong bytesReleased = new AtomicLong(0L);

    @Override
    public void blockAllocated() {
        this.blocksAllocated.incrementAndGet();
    }

    @Override
    public void blockReleased() {
        this.blocksReleased.incrementAndGet();
    }

    @Override
    public void diskBlockAllocated() {
        this.diskBlocksAllocated.incrementAndGet();
    }

    @Override
    public void diskBlockReleased() {
        this.diskBlocksReleased.incrementAndGet();
    }

    @Override
    public int getBlocksAllocated() {
        return this.blocksAllocated.get();
    }

    @Override
    public int getBlocksReleased() {
        return this.blocksReleased.get();
    }

    @Override
    public int getDiskBlocksAllocated() {
        return this.diskBlocksAllocated.get();
    }

    @Override
    public int getDiskBlocksReleased() {
        return this.diskBlocksReleased.get();
    }

    @Override
    public void bytesAllocated(long size) {
        this.bytesAllocated.getAndAdd(size);
    }

    @Override
    public void bytesReleased(long size) {
        this.bytesReleased.getAndAdd(size);
    }

    @Override
    public long getBytesAllocated() {
        return this.bytesAllocated.get();
    }

    @Override
    public long getBytesReleased() {
        return this.bytesReleased.get();
    }
}

