/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.buffer;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.mapred.nativetask.buffer.BufferType;
import org.apache.hadoop.util.DirectBufferPool;

@InterfaceAudience.Private
public class InputBuffer
implements Closeable {
    static DirectBufferPool bufferPool = new DirectBufferPool();
    private ByteBuffer byteBuffer;
    private final BufferType type;

    public InputBuffer(BufferType type, int inputSize) throws IOException {
        int capacity = inputSize;
        this.type = type;
        if (capacity > 0) {
            switch (type) {
                case DIRECT_BUFFER: {
                    this.byteBuffer = bufferPool.getBuffer(capacity);
                    this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
                    break;
                }
                case HEAP_BUFFER: {
                    this.byteBuffer = ByteBuffer.allocate(capacity);
                    this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
            }
            this.byteBuffer.position(0);
            this.byteBuffer.limit(0);
        }
    }

    public BufferType getType() {
        return this.type;
    }

    public InputBuffer(byte[] bytes) {
        this.type = BufferType.HEAP_BUFFER;
        if (bytes.length > 0) {
            this.byteBuffer = ByteBuffer.wrap(bytes);
            this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
            this.byteBuffer.position(0);
            this.byteBuffer.limit(0);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int length() {
        if (null == this.byteBuffer) {
            return 0;
        }
        return this.byteBuffer.limit();
    }

    public void rewind(int startOffset, int length) {
        if (null == this.byteBuffer) {
            return;
        }
        this.byteBuffer.position(startOffset);
        this.byteBuffer.limit(length);
    }

    public int remaining() {
        if (null == this.byteBuffer) {
            return 0;
        }
        return this.byteBuffer.remaining();
    }

    public int position() {
        if (null == this.byteBuffer) {
            return 0;
        }
        return this.byteBuffer.position();
    }

    public int position(int pos) {
        if (null == this.byteBuffer) {
            return 0;
        }
        this.byteBuffer.position(pos);
        return pos;
    }

    public int capacity() {
        if (null == this.byteBuffer) {
            return 0;
        }
        return this.byteBuffer.capacity();
    }

    public byte[] array() {
        if (null == this.byteBuffer) {
            return null;
        }
        return this.byteBuffer.array();
    }

    @Override
    public void close() {
        if (this.byteBuffer != null && this.byteBuffer.isDirect()) {
            bufferPool.returnBuffer(this.byteBuffer);
            this.byteBuffer = null;
        }
    }
}

