/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.federation;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationStateStoreServiceMetrics;
import org.apache.hadoop.yarn.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationClientMethod<R> {
    public static final Logger LOG = LoggerFactory.getLogger(FederationClientMethod.class);
    private final Object[] params;
    private final Class<?>[] types;
    private final String methodName;
    private FederationStateStore stateStoreClient = null;
    private Clock clock = null;
    private Class<R> clazz;

    public FederationClientMethod(String method, Class<?>[] pTypes, Object ... pParams) throws YarnException {
        if (pParams.length != pTypes.length) {
            throw new YarnException("Invalid parameters for method " + method);
        }
        this.params = pParams;
        this.types = Arrays.copyOf(pTypes, pTypes.length);
        this.methodName = method;
    }

    public FederationClientMethod(String method, Class pTypes, Object pParams) throws YarnException {
        this(method, new Class[]{pTypes}, pParams);
    }

    public FederationClientMethod(String method, Class pTypes, Object pParams, Class<R> rTypes, FederationStateStore fedStateStore, Clock fedClock) throws YarnException {
        this(method, pTypes, pParams);
        this.stateStoreClient = fedStateStore;
        this.clock = fedClock;
        this.clazz = rTypes;
    }

    public Object[] getParams() {
        return Arrays.copyOf(this.params, this.params.length);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getTypes() {
        return Arrays.copyOf(this.types, this.types.length);
    }

    protected R invoke() throws YarnException {
        try {
            long startTime = this.clock.getTime();
            Method method = FederationStateStore.class.getMethod(this.methodName, this.types);
            R result = this.clazz.cast(method.invoke((Object)this.stateStoreClient, this.params));
            long stopTime = this.clock.getTime();
            FederationStateStoreServiceMetrics.succeededStateStoreServiceCall(this.methodName, stopTime - startTime);
            return result;
        }
        catch (Exception e) {
            LOG.error("stateStoreClient call method {} error.", (Object)this.methodName, (Object)e);
            FederationStateStoreServiceMetrics.failedStateStoreServiceCall(this.methodName);
            throw new YarnException((Throwable)e);
        }
    }
}

