/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind;

import org.apache.hadoop.shaded.org.ehcache.core.spi.service.ExecutionService;
import org.apache.hadoop.shaded.org.ehcache.core.spi.service.ServiceFactory;
import org.apache.hadoop.shaded.org.ehcache.impl.config.loaderwriter.writebehind.WriteBehindProviderConfiguration;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.StripedWriteBehind;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.loaderwriter.writebehind.WriteBehind;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.WriteBehindConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.loaderwriter.WriteBehindProvider;
import org.apache.hadoop.shaded.org.ehcache.spi.service.Service;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceCreationConfiguration;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceDependencies;
import org.apache.hadoop.shaded.org.ehcache.spi.service.ServiceProvider;
import org.apache.hadoop.shaded.org.osgi.service.component.annotations.Component;

@Component
public class WriteBehindProviderFactory
implements ServiceFactory<WriteBehindProvider> {
    @Override
    public WriteBehindProvider create(ServiceCreationConfiguration<WriteBehindProvider, ?> configuration) {
        if (configuration == null) {
            return new Provider();
        }
        if (configuration instanceof WriteBehindProviderConfiguration) {
            return new Provider(((WriteBehindProviderConfiguration)configuration).getThreadPoolAlias());
        }
        throw new IllegalArgumentException("WriteBehind configuration must not be provided at CacheManager level");
    }

    @Override
    public Class<WriteBehindProvider> getServiceType() {
        return WriteBehindProvider.class;
    }

    @ServiceDependencies(value={ExecutionService.class})
    public static class Provider
    implements WriteBehindProvider {
        private final String threadPoolAlias;
        private volatile ExecutionService executionService;

        protected Provider() {
            this(null);
        }

        protected Provider(String threadPoolAlias) {
            this.threadPoolAlias = threadPoolAlias;
        }

        @Override
        public void stop() {
        }

        @Override
        public void start(ServiceProvider<Service> serviceProvider) {
            this.executionService = serviceProvider.getService(ExecutionService.class);
        }

        public <K, V> WriteBehind<K, V> createWriteBehindLoaderWriter(CacheLoaderWriter<K, V> cacheLoaderWriter, WriteBehindConfiguration<?> configuration) {
            if (cacheLoaderWriter == null) {
                throw new NullPointerException("WriteBehind requires a non null CacheLoaderWriter.");
            }
            return new StripedWriteBehind<K, V>(this.executionService, this.threadPoolAlias, configuration, cacheLoaderWriter);
        }

        @Override
        public void releaseWriteBehindLoaderWriter(CacheLoaderWriter<?, ?> cacheLoaderWriter) {
            if (cacheLoaderWriter != null) {
                ((WriteBehind)cacheLoaderWriter).stop();
            }
        }
    }
}

