/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.decoders;

import java.nio.ByteBuffer;
import org.apache.hadoop.shaded.javax.websocket.DecodeException;
import org.apache.hadoop.shaded.javax.websocket.Decoder;
import org.apache.hadoop.shaded.javax.websocket.PongMessage;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class PongMessageDecoder
extends AbstractDecoder
implements Decoder.Binary<PongMessage> {
    @Override
    public PongMessage decode(ByteBuffer bytes) throws DecodeException {
        return new PongMsg(bytes);
    }

    @Override
    public boolean willDecode(ByteBuffer bytes) {
        return true;
    }

    private static class PongMsg
    implements PongMessage {
        private final ByteBuffer bytes;

        public PongMsg(ByteBuffer buf) {
            int len = buf.remaining();
            this.bytes = ByteBuffer.allocate(len);
            BufferUtil.put((ByteBuffer)buf, (ByteBuffer)this.bytes);
            BufferUtil.flipToFlush((ByteBuffer)this.bytes, (int)0);
        }

        @Override
        public ByteBuffer getApplicationData() {
            return this.bytes;
        }
    }
}

