/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc;

import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.shaded.com.microsoft.aad.adal4j.AuthenticationContext;
import org.apache.hadoop.shaded.com.microsoft.aad.adal4j.AuthenticationException;
import org.apache.hadoop.shaded.com.microsoft.aad.adal4j.AuthenticationResult;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerConnection;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SQLServerException;
import org.apache.hadoop.shaded.com.microsoft.sqlserver.jdbc.SqlFedAuthToken;

class SQLServerADAL4JUtils {
    SQLServerADAL4JUtils() {
    }

    static SqlFedAuthToken getSqlFedAuthToken(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String user, String password, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        try {
            SqlFedAuthToken fedAuthToken;
            AuthenticationContext context = new AuthenticationContext(fedAuthInfo.stsurl, false, executorService);
            Future future = context.acquireToken(fedAuthInfo.spn, "7f98cb04-cd1e-40df-9140-3bf7e2cea4db", user, password, null);
            AuthenticationResult authenticationResult = (AuthenticationResult)future.get();
            SqlFedAuthToken sqlFedAuthToken = fedAuthToken = new SqlFedAuthToken(authenticationResult.getAccessToken(), authenticationResult.getExpiresOnDate());
            return sqlFedAuthToken;
        }
        catch (InterruptedException | MalformedURLException e) {
            throw new SQLServerException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_ADALExecution"));
            Object[] msgArgs = new Object[]{user, authenticationString};
            String correctedErrorMessage = e.getCause().getMessage().replaceAll("\\\\r\\\\n", "\r\n");
            AuthenticationException correctedAuthenticationException = new AuthenticationException(correctedErrorMessage);
            ExecutionException correctedExecutionException = new ExecutionException((Throwable)correctedAuthenticationException);
            throw new SQLServerException(form.format(msgArgs), null, 0, (Throwable)correctedExecutionException);
        }
        finally {
            executorService.shutdown();
        }
    }
}

