/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.websocket;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.metrics.Clock;
import io.reactivex.netty.metrics.MetricEventsSubject;
import io.reactivex.netty.protocol.http.websocket.WebSocketClientMetricsEvent;
import io.reactivex.netty.protocol.http.websocket.WebSocketClientMetricsHandlers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketClientHandler.class);
    private final WebSocketClientHandshaker handshaker;
    private final int maxFramePayloadLength;
    private final boolean messageAggregation;
    private final MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;
    private ChannelPromise handshakeFuture;
    private long handshakeStartTime;

    public WebSocketClientHandler(WebSocketClientHandshaker handshaker, int maxFramePayloadLength, boolean messageAggregation, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this.handshaker = handshaker;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.messageAggregation = messageAggregation;
        this.eventsSubject = eventsSubject;
    }

    public void addHandshakeFinishedListener(ChannelFutureListener listener) {
        this.handshakeFuture.addListener((GenericFutureListener)listener);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshakeStartTime = Clock.newStartTimeMillis();
        this.eventsSubject.onEvent(WebSocketClientMetricsEvent.HANDSHAKE_START);
        this.handshaker.handshake(ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            this.finishHandshake(ctx, (FullHttpResponse)msg, ch);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void finishHandshake(ChannelHandlerContext ctx, FullHttpResponse msg, Channel ch) {
        HttpObjectAggregator aggregator;
        try {
            this.handshaker.finishHandshake(ch, msg);
        }
        catch (WebSocketHandshakeException e) {
            this.eventsSubject.onEvent((ClientMetricsEvent<?>)WebSocketClientMetricsEvent.HANDSHAKE_FAILURE, Clock.onEndMillis(this.handshakeStartTime));
            this.handshakeFuture.setFailure((Throwable)e);
            ctx.close();
            return;
        }
        this.eventsSubject.onEvent((ClientMetricsEvent<?>)WebSocketClientMetricsEvent.HANDSHAKE_SUCCESS, Clock.onEndMillis(this.handshakeStartTime));
        ChannelPipeline p = ctx.pipeline();
        ChannelHandlerContext nettyDecoderCtx = p.context(WebSocketFrameDecoder.class);
        p.addAfter(nettyDecoderCtx.name(), "websocket-read-metrics", (ChannelHandler)new WebSocketClientMetricsHandlers.ClientReadMetricsHandler(this.eventsSubject));
        ChannelHandlerContext nettyEncoderCtx = p.context(WebSocketFrameEncoder.class);
        p.addAfter(nettyEncoderCtx.name(), "websocket-write-metrics", (ChannelHandler)new WebSocketClientMetricsHandlers.ClientWriteMetricsHandler(this.eventsSubject));
        if (this.messageAggregation) {
            p.addAfter("websocket-read-metrics", "websocket-frame-aggregator", (ChannelHandler)new WebSocketFrameAggregator(this.maxFramePayloadLength));
        }
        if ((aggregator = (HttpObjectAggregator)p.get(HttpObjectAggregator.class)) != null) {
            p.remove((ChannelHandler)aggregator);
        }
        this.handshakeFuture.setSuccess();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        logger.error("Exception caught, closing the channel.", cause);
        ctx.close();
    }
}

