/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.sharedcachemanager.SharedCacheManager;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.CleanerMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.ClientSCMMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.SharedCacheUploaderMetrics;
import org.apache.hadoop.yarn.server.sharedcachemanager.webapp.SCMMetricsInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;
import org.apache.hadoop.yarn.webapp.view.TwoColumnLayout;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SCMOverviewPage
extends TwoColumnLayout {
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.set("ui.accordion.id", "nav");
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:0}");
    }

    protected Class<? extends SubView> content() {
        return SCMOverviewBlock.class;
    }

    protected Class<? extends SubView> nav() {
        return SCMOverviewNavBlock.class;
    }

    private static class SCMOverviewBlock
    extends HtmlBlock {
        final SharedCacheManager scm;

        @Inject
        SCMOverviewBlock(SharedCacheManager scm, View.ViewContext ctx) {
            super(ctx);
            this.scm = scm;
        }

        protected void render(HtmlBlock.Block html) {
            SCMMetricsInfo metricsInfo = new SCMMetricsInfo(CleanerMetrics.getInstance(), ClientSCMMetrics.getInstance(), SharedCacheUploaderMetrics.getInstance());
            this.info("Shared Cache Manager overview")._("Started on:", (Object)Times.format((long)this.scm.getStartTime()))._("Cache hits: ", (Object)metricsInfo.getCacheHits())._("Cache misses: ", (Object)metricsInfo.getCacheMisses())._("Cache releases: ", (Object)metricsInfo.getCacheReleases())._("Accepted uploads: ", (Object)metricsInfo.getAcceptedUploads())._("Rejected uploads: ", (Object)metricsInfo.getRejectUploads())._("Deleted files by the cleaner: ", (Object)metricsInfo.getTotalDeletedFiles())._("Processed files by the cleaner: ", (Object)metricsInfo.getTotalProcessedFiles());
            html._(InfoBlock.class);
        }
    }

    private static class SCMOverviewNavBlock
    extends HtmlBlock {
        private SCMOverviewNavBlock() {
        }

        protected void render(HtmlBlock.Block html) {
            ((Hamlet.DIV)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)((Hamlet.UL)html.div("#nav").h3("Tools").ul().li().a("/conf", "Configuration")._()).li().a("/stacks", "Thread dump")._()).li().a("/logs", "Logs")._()).li().a("/metrics", "Metrics")._())._())._();
        }
    }
}

