/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import java.text.NumberFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.AggregationOperation;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.Attribute;

public final class HBaseTimelineSchemaUtils {
    public static final long MILLIS_ONE_DAY = 86400000L;
    private static final ThreadLocal<NumberFormat> APP_ID_FORMAT = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(4);
            return fmt;
        }
    };

    private HBaseTimelineSchemaUtils() {
    }

    public static Attribute[] combineAttributes(Attribute[] attributes, AggregationOperation aggOp) {
        int newLength = HBaseTimelineSchemaUtils.getNewLengthCombinedAttributes(attributes, aggOp);
        Attribute[] combinedAttributes = new Attribute[newLength];
        if (attributes != null) {
            System.arraycopy(attributes, 0, combinedAttributes, 0, attributes.length);
        }
        if (aggOp != null) {
            Attribute a2;
            combinedAttributes[newLength - 1] = a2 = aggOp.getAttribute();
        }
        return combinedAttributes;
    }

    private static int getNewLengthCombinedAttributes(Attribute[] attributes, AggregationOperation aggOp) {
        int oldLength = HBaseTimelineSchemaUtils.getAttributesLength(attributes);
        int aggLength = HBaseTimelineSchemaUtils.getAppOpLength(aggOp);
        return oldLength + aggLength;
    }

    private static int getAppOpLength(AggregationOperation aggOp) {
        if (aggOp != null) {
            return 1;
        }
        return 0;
    }

    private static int getAttributesLength(Attribute[] attributes) {
        if (attributes != null) {
            return attributes.length;
        }
        return 0;
    }

    public static int invertInt(int key) {
        return Integer.MAX_VALUE - key;
    }

    public static long getTopOfTheDayTimestamp(long ts) {
        long dayTimestamp = ts - ts % 86400000L;
        return dayTimestamp;
    }

    public static boolean isIntegralValue(Object obj) {
        return obj instanceof Short || obj instanceof Integer || obj instanceof Long;
    }

    public static String convertApplicationIdToString(ApplicationId appId) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("application");
        sb.append("_");
        sb.append(appId.getClusterTimestamp());
        sb.append('_');
        sb.append(APP_ID_FORMAT.get().format(appId.getId()));
        return sb.toString();
    }
}

