/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.util;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NodeManagerHardwareUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NodeManagerHardwareUtils.class);

    private static boolean isHardwareDetectionEnabled(Configuration conf) {
        return conf.getBoolean("yarn.nodemanager.resource.detect-hardware-capabilities", false);
    }

    public static int getNodeCPUs(Configuration conf) {
        ResourceCalculatorPlugin plugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf);
        return NodeManagerHardwareUtils.getNodeCPUs(plugin, conf);
    }

    public static int getNodeCPUs(ResourceCalculatorPlugin plugin, Configuration conf) {
        int numProcessors = plugin.getNumProcessors();
        boolean countLogicalCores = conf.getBoolean("yarn.nodemanager.resource.count-logical-processors-as-cores", false);
        if (!countLogicalCores) {
            numProcessors = plugin.getNumCores();
        }
        return numProcessors;
    }

    public static float getContainersCPUs(Configuration conf) {
        ResourceCalculatorPlugin plugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf);
        return NodeManagerHardwareUtils.getContainersCPUs(plugin, conf);
    }

    public static float getContainersCPUs(ResourceCalculatorPlugin plugin, Configuration conf) {
        int numProcessors = NodeManagerHardwareUtils.getNodeCPUs(plugin, conf);
        int nodeCpuPercentage = NodeManagerHardwareUtils.getNodeCpuPercentage(conf);
        return (float)(nodeCpuPercentage * numProcessors) / 100.0f;
    }

    public static int getNodeCpuPercentage(Configuration conf) {
        int nodeCpuPercentage = Math.min(conf.getInt("yarn.nodemanager.resource.percentage-physical-cpu-limit", 100), 100);
        if ((nodeCpuPercentage = Math.max(0, nodeCpuPercentage)) == 0) {
            String message = "Illegal value for yarn.nodemanager.resource.percentage-physical-cpu-limit. Value cannot be less than or equal to 0.";
            throw new IllegalArgumentException(message);
        }
        return nodeCpuPercentage;
    }

    private static int getConfiguredVCores(Configuration conf) {
        int cores = conf.getInt("yarn.nodemanager.resource.cpu-vcores", 8);
        if (cores == -1) {
            cores = 8;
        }
        return cores;
    }

    public static int getVCores(Configuration conf) {
        if (!NodeManagerHardwareUtils.isHardwareDetectionEnabled(conf)) {
            return NodeManagerHardwareUtils.getConfiguredVCores(conf);
        }
        ResourceCalculatorPlugin plugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf);
        if (plugin == null) {
            return NodeManagerHardwareUtils.getConfiguredVCores(conf);
        }
        return NodeManagerHardwareUtils.getVCoresInternal(plugin, conf);
    }

    public static int getVCores(ResourceCalculatorPlugin plugin, Configuration conf) {
        if (!NodeManagerHardwareUtils.isHardwareDetectionEnabled(conf) || plugin == null) {
            return NodeManagerHardwareUtils.getConfiguredVCores(conf);
        }
        return NodeManagerHardwareUtils.getVCoresInternal(plugin, conf);
    }

    private static int getVCoresInternal(ResourceCalculatorPlugin plugin, Configuration conf) {
        int cores = conf.getInt("yarn.nodemanager.resource.cpu-vcores", -1);
        if (cores == -1) {
            float physicalCores = NodeManagerHardwareUtils.getContainersCPUs(plugin, conf);
            float multiplier = conf.getFloat("yarn.nodemanager.resource.pcores-vcores-multiplier", 1.0f);
            if (multiplier > 0.0f) {
                float tmp = physicalCores * multiplier;
                cores = tmp > 0.0f && tmp < 1.0f ? 1 : (int)tmp;
            } else {
                String message = "Illegal value for yarn.nodemanager.resource.pcores-vcores-multiplier. Value must be greater than 0.";
                throw new IllegalArgumentException(message);
            }
        }
        if (cores <= 0) {
            String message = "Illegal value for yarn.nodemanager.resource.cpu-vcores. Value must be greater than 0.";
            throw new IllegalArgumentException(message);
        }
        return cores;
    }

    private static long getConfiguredMemoryMB(Configuration conf) {
        long memoryMb = conf.getLong("yarn.nodemanager.resource.memory-mb", 8192L);
        if (memoryMb == -1L) {
            memoryMb = 8192L;
        }
        return memoryMb;
    }

    public static long getContainerMemoryMB(Configuration conf) {
        if (!NodeManagerHardwareUtils.isHardwareDetectionEnabled(conf)) {
            return NodeManagerHardwareUtils.getConfiguredMemoryMB(conf);
        }
        ResourceCalculatorPlugin plugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf);
        if (plugin == null) {
            return NodeManagerHardwareUtils.getConfiguredMemoryMB(conf);
        }
        return NodeManagerHardwareUtils.getContainerMemoryMBInternal(plugin, conf);
    }

    public static long getContainerMemoryMB(ResourceCalculatorPlugin plugin, Configuration conf) {
        if (!NodeManagerHardwareUtils.isHardwareDetectionEnabled(conf) || plugin == null) {
            return NodeManagerHardwareUtils.getConfiguredMemoryMB(conf);
        }
        return NodeManagerHardwareUtils.getContainerMemoryMBInternal(plugin, conf);
    }

    private static long getContainerMemoryMBInternal(ResourceCalculatorPlugin plugin, Configuration conf) {
        long memoryMb = conf.getInt("yarn.nodemanager.resource.memory-mb", -1);
        if (memoryMb == -1L) {
            long physicalMemoryMB = plugin.getPhysicalMemorySize() / 0x100000L;
            long hadoopHeapSizeMB = Runtime.getRuntime().maxMemory() / 0x100000L;
            long containerPhysicalMemoryMB = (long)(0.8f * (float)(physicalMemoryMB - 2L * hadoopHeapSizeMB));
            long reservedMemoryMB = conf.getInt("yarn.nodemanager.resource.system-reserved-memory-mb", -1);
            if (reservedMemoryMB != -1L) {
                containerPhysicalMemoryMB = physicalMemoryMB - reservedMemoryMB;
            }
            if (containerPhysicalMemoryMB <= 0L) {
                LOG.error("Calculated memory for YARN containers is too low. Node memory is " + physicalMemoryMB + " MB, system reserved memory is " + reservedMemoryMB + " MB.");
            }
            memoryMb = containerPhysicalMemoryMB = Math.max(containerPhysicalMemoryMB, 0L);
        }
        if (memoryMb <= 0L) {
            String message = "Illegal value for yarn.nodemanager.resource.memory-mb. Value must be greater than 0.";
            throw new IllegalArgumentException(message);
        }
        return memoryMb;
    }

    public static Resource getNodeResources(Configuration configuration) {
        Long value;
        Configuration conf = new Configuration(configuration);
        String memory = ResourceInformation.MEMORY_MB.getName();
        String vcores = ResourceInformation.VCORES.getName();
        Resource ret = Resource.newInstance((int)0, (int)0);
        Map resourceInformation = ResourceUtils.getNodeResourceInformation((Configuration)conf);
        for (Map.Entry entry : resourceInformation.entrySet()) {
            ret.setResourceInformation((String)entry.getKey(), (ResourceInformation)entry.getValue());
            LOG.debug("Setting key " + (String)entry.getKey() + " to " + entry.getValue());
        }
        if (resourceInformation.containsKey(memory)) {
            value = ((ResourceInformation)resourceInformation.get(memory)).getValue();
            if (value > Integer.MAX_VALUE) {
                throw new YarnRuntimeException("Value '" + value + "' for resource memory is more than the maximum for an integer.");
            }
            ResourceInformation memResInfo = (ResourceInformation)resourceInformation.get(memory);
            if (memResInfo.getValue() == 0L) {
                ret.setMemorySize(NodeManagerHardwareUtils.getContainerMemoryMB(conf));
                LOG.debug("Set memory to " + ret.getMemorySize());
            }
        }
        if (resourceInformation.containsKey(vcores)) {
            value = ((ResourceInformation)resourceInformation.get(vcores)).getValue();
            if (value > Integer.MAX_VALUE) {
                throw new YarnRuntimeException("Value '" + value + "' for resource vcores is more than the maximum for an integer.");
            }
            ResourceInformation vcoresResInfo = (ResourceInformation)resourceInformation.get(vcores);
            if (vcoresResInfo.getValue() == 0L) {
                ret.setVirtualCores(NodeManagerHardwareUtils.getVCores(conf));
                LOG.debug("Set vcores to " + ret.getVirtualCores());
            }
        }
        LOG.debug("Node resource information map is " + ret);
        return ret;
    }
}

