/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.reader;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowActivityEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.FlowRunEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineDataToRetrieve;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineEntityFilters;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineReaderContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.BaseTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.ColumnRWHelper;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.KeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.LongKeyConverter;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityColumnPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKey;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityRowKeyPrefix;
import org.apache.hadoop.yarn.server.timelineservice.storage.flow.FlowActivityTableRW;
import org.apache.hadoop.yarn.server.timelineservice.storage.reader.TimelineEntityReader;
import org.apache.hadoop.yarn.webapp.BadRequestException;

class FlowActivityEntityReader
extends TimelineEntityReader {
    private static final FlowActivityTableRW FLOW_ACTIVITY_TABLE = new FlowActivityTableRW();
    private final KeyConverter<Long> longKeyConverter = new LongKeyConverter();

    FlowActivityEntityReader(TimelineReaderContext ctxt, TimelineEntityFilters entityFilters, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, entityFilters, toRetrieve);
    }

    FlowActivityEntityReader(TimelineReaderContext ctxt, TimelineDataToRetrieve toRetrieve) {
        super(ctxt, toRetrieve);
    }

    @Override
    protected BaseTableRW<?> getTable() {
        return FLOW_ACTIVITY_TABLE;
    }

    @Override
    protected void validateParams() {
        Preconditions.checkNotNull((Object)this.getContext().getClusterId(), (Object)"clusterId shouldn't be null");
    }

    @Override
    protected void augmentParams(Configuration hbaseConf, Connection conn) throws IOException {
        this.createFiltersIfNull();
    }

    @Override
    protected FilterList constructFilterListBasedOnFilters() throws IOException {
        return null;
    }

    @Override
    protected FilterList constructFilterListBasedOnFields(Set<String> cfsInFields) {
        return null;
    }

    @Override
    protected Result getResult(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        throw new UnsupportedOperationException("we don't support a single entity query");
    }

    @Override
    protected ResultScanner getResults(Configuration hbaseConf, Connection conn, FilterList filterList) throws IOException {
        Scan scan = new Scan();
        String clusterId = this.getContext().getClusterId();
        if (this.getFilters().getFromId() == null && this.getFilters().getCreatedTimeBegin() == 0L && this.getFilters().getCreatedTimeEnd() == Long.MAX_VALUE) {
            scan.setRowPrefixFilter(new FlowActivityRowKeyPrefix(clusterId).getRowKeyPrefix());
        } else if (this.getFilters().getFromId() != null) {
            FlowActivityRowKey key = null;
            try {
                key = FlowActivityRowKey.parseRowKeyFromString((String)this.getFilters().getFromId());
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Invalid filter fromid is provided.");
            }
            if (!clusterId.equals(key.getClusterId())) {
                throw new BadRequestException("fromid doesn't belong to clusterId=" + clusterId);
            }
            scan.setStartRow(key.getRowKey());
            scan.setStopRow(new FlowActivityRowKeyPrefix(clusterId, Long.valueOf(this.getFilters().getCreatedTimeBegin() <= 0L ? 0L : this.getFilters().getCreatedTimeBegin() - 1L)).getRowKeyPrefix());
        } else {
            scan.setStartRow(new FlowActivityRowKeyPrefix(clusterId, Long.valueOf(this.getFilters().getCreatedTimeEnd())).getRowKeyPrefix());
            scan.setStopRow(new FlowActivityRowKeyPrefix(clusterId, Long.valueOf(this.getFilters().getCreatedTimeBegin() <= 0L ? 0L : this.getFilters().getCreatedTimeBegin() - 1L)).getRowKeyPrefix());
        }
        scan.setFilter((Filter)new PageFilter(this.getFilters().getLimit()));
        return this.getTable().getResultScanner(hbaseConf, conn, scan);
    }

    @Override
    protected TimelineEntity parseEntity(Result result) throws IOException {
        FlowActivityRowKey rowKey = FlowActivityRowKey.parseRowKey((byte[])result.getRow());
        Long time = rowKey.getDayTimestamp();
        String user = rowKey.getUserId();
        String flowName = rowKey.getFlowName();
        FlowActivityEntity flowActivity = new FlowActivityEntity(this.getContext().getClusterId(), time.longValue(), user, flowName);
        flowActivity.setId(flowActivity.getId());
        Map<Long, Object> runIdsMap = ColumnRWHelper.readResults(result, FlowActivityColumnPrefix.RUN_ID, this.longKeyConverter);
        for (Map.Entry<Long, Object> e : runIdsMap.entrySet()) {
            Long runId = e.getKey();
            String version = (String)e.getValue();
            FlowRunEntity flowRun = new FlowRunEntity();
            flowRun.setUser(user);
            flowRun.setName(flowName);
            flowRun.setRunId(runId.longValue());
            flowRun.setVersion(version);
            flowRun.setId(flowRun.getId());
            flowActivity.addFlowRun(flowRun);
        }
        flowActivity.getInfo().put("FROM_ID", rowKey.getRowKeyAsString());
        return flowActivity;
    }
}

