/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.router.clientrm.AbstractClientRequestInterceptor;
import org.apache.hadoop.yarn.server.router.clientrm.ClientRequestInterceptor;

public class DefaultClientRequestInterceptor
extends AbstractClientRequestInterceptor {
    private ApplicationClientProtocol clientRMProxy;

    @Override
    public void init(String userName) {
        super.init(userName);
        final Configuration conf = this.getConf();
        try {
            this.clientRMProxy = (ApplicationClientProtocol)this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationClientProtocol>(){

                @Override
                public ApplicationClientProtocol run() throws Exception {
                    return (ApplicationClientProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationClientProtocol.class);
                }
            });
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Unable to create the interface to reach the YarnRM", (Throwable)e);
        }
    }

    @Override
    public void setNextInterceptor(ClientRequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on DefaultRequestInterceptor,which should be the last one in the chain Check if the interceptor pipeline configuration is correct");
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getNewApplication(request);
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException, IOException {
        return this.clientRMProxy.submitApplication(request);
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException, IOException {
        return this.clientRMProxy.forceKillApplication(request);
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getClusterMetrics(request);
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getClusterNodes(request);
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getQueueInfo(request);
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getQueueUserAcls(request);
    }

    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException, IOException {
        return this.clientRMProxy.moveApplicationAcrossQueues(request);
    }

    public GetNewReservationResponse getNewReservation(GetNewReservationRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getNewReservation(request);
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        return this.clientRMProxy.submitReservation(request);
    }

    public ReservationListResponse listReservations(ReservationListRequest request) throws YarnException, IOException {
        return this.clientRMProxy.listReservations(request);
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        return this.clientRMProxy.updateReservation(request);
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        return this.clientRMProxy.deleteReservation(request);
    }

    public GetNodesToLabelsResponse getNodeToLabels(GetNodesToLabelsRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getNodeToLabels(request);
    }

    public GetLabelsToNodesResponse getLabelsToNodes(GetLabelsToNodesRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getLabelsToNodes(request);
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getClusterNodeLabels(request);
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getApplicationReport(request);
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getApplications(request);
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getApplicationAttemptReport(request);
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getApplicationAttempts(request);
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getContainerReport(request);
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getContainers(request);
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getDelegationToken(request);
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
        return this.clientRMProxy.renewDelegationToken(request);
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
        return this.clientRMProxy.cancelDelegationToken(request);
    }

    public FailApplicationAttemptResponse failApplicationAttempt(FailApplicationAttemptRequest request) throws YarnException, IOException {
        return this.clientRMProxy.failApplicationAttempt(request);
    }

    public UpdateApplicationPriorityResponse updateApplicationPriority(UpdateApplicationPriorityRequest request) throws YarnException, IOException {
        return this.clientRMProxy.updateApplicationPriority(request);
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        return this.clientRMProxy.signalToContainer(request);
    }

    public UpdateApplicationTimeoutsResponse updateApplicationTimeouts(UpdateApplicationTimeoutsRequest request) throws YarnException, IOException {
        return this.clientRMProxy.updateApplicationTimeouts(request);
    }

    public GetAllResourceTypeInfoResponse getResourceTypeInfo(GetAllResourceTypeInfoRequest request) throws YarnException, IOException {
        return this.clientRMProxy.getResourceTypeInfo(request);
    }

    @VisibleForTesting
    public void setRMClient(ApplicationClientProtocol clientRM) {
        this.clientRMProxy = clientRM;
    }
}

