/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.util.Map;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Attribute;
import software.amazon.s3.analyticsaccelerator.common.telemetry.EpochFormatter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Metric;
import software.amazon.s3.analyticsaccelerator.common.telemetry.MetricMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.OperationMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryFormat;

public class DefaultTelemetryFormat
implements TelemetryFormat {
    public static final String TELEMETRY_CONFIG_ID = "default";
    private static final String METRIC_FORMAT_STRING = "[%s] %s: %,.2f";
    private static final String OPERATION_START_FORMAT_STRING = "[%s] [  start] %s";
    private static final String OPERATION_ERROR_FORMAT_STRING = " [%s: '%s']";
    public static final String OPERATION_COMPLETE_FORMAT_STRING = "[%s] [%s] %s: %,d ns";
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";

    @Override
    public String renderDatapointMeasurement(@NonNull TelemetryDatapointMeasurement datapointMeasurement, @NonNull EpochFormatter epochFormatter) {
        if (datapointMeasurement == null) {
            throw new NullPointerException("datapointMeasurement is marked non-null but is null");
        }
        if (epochFormatter == null) {
            throw new NullPointerException("epochFormatter is marked non-null but is null");
        }
        return datapointMeasurement.toString(this, epochFormatter);
    }

    @Override
    public String renderMetricMeasurement(@NonNull MetricMeasurement metricMeasurement, @NonNull EpochFormatter epochFormatter) {
        if (metricMeasurement == null) {
            throw new NullPointerException("metricMeasurement is marked non-null but is null");
        }
        if (epochFormatter == null) {
            throw new NullPointerException("epochFormatter is marked non-null but is null");
        }
        return String.format(METRIC_FORMAT_STRING, epochFormatter.formatNanos(metricMeasurement.getEpochTimestampNanos()), this.renderMetric(metricMeasurement.getMetric()), metricMeasurement.getValue());
    }

    @Override
    public String renderOperationStart(@NonNull Operation operation, long epochTimestampNanos, @NonNull EpochFormatter epochFormatter) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (epochFormatter == null) {
            throw new NullPointerException("epochFormatter is marked non-null but is null");
        }
        return String.format(OPERATION_START_FORMAT_STRING, epochFormatter.formatNanos(epochTimestampNanos), this.renderOperation(operation));
    }

    @Override
    public String renderOperationEnd(@NonNull OperationMeasurement operationMeasurement, @NonNull EpochFormatter epochFormatter) {
        if (operationMeasurement == null) {
            throw new NullPointerException("operationMeasurement is marked non-null but is null");
        }
        if (epochFormatter == null) {
            throw new NullPointerException("epochFormatter is marked non-null but is null");
        }
        String result = String.format(OPERATION_COMPLETE_FORMAT_STRING, epochFormatter.formatNanos(operationMeasurement.getEpochTimestampNanos()), operationMeasurement.succeeded() ? SUCCESS : FAILURE, this.renderOperation(operationMeasurement.getOperation()), operationMeasurement.getElapsedTimeNanos());
        if (operationMeasurement.getError().isPresent()) {
            result = result + String.format(OPERATION_ERROR_FORMAT_STRING, operationMeasurement.getError().get().getClass().getCanonicalName(), operationMeasurement.getError().get().getMessage());
        }
        return result;
    }

    @Override
    public String renderOperation(Operation operation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(operation.getId());
        operation.getParent().ifPresent(parent -> {
            stringBuilder.append("<-");
            stringBuilder.append(parent.getId());
        });
        stringBuilder.append("] ");
        stringBuilder.append(operation.getName());
        stringBuilder.append(this.renderTelemetryAttributes(operation.getAttributes()));
        return stringBuilder.toString();
    }

    @Override
    public String renderTelemetryAttributes(Map<String, Attribute> attributes) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!attributes.isEmpty()) {
            stringBuilder.append("(");
            int count = 0;
            for (Attribute attribute : attributes.values()) {
                stringBuilder.append(attribute.getName());
                stringBuilder.append("=");
                stringBuilder.append(attribute.getValue());
                if (++count == attributes.size()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private String renderMetric(Metric metric) {
        StringBuilder sb = new StringBuilder();
        sb.append(metric.getName());
        sb.append(this.renderTelemetryAttributes(metric.getAttributes()));
        return sb.toString();
    }
}

