/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.executor;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class ContainerExecContext {
    private final String user;
    private final String appId;
    private final Container container;
    private String command;
    private final LocalDirsHandlerService localDirsHandler;

    private ContainerExecContext(Builder builder) {
        this.user = builder.user;
        this.appId = builder.appId;
        this.container = builder.container;
        this.command = builder.command;
        this.localDirsHandler = builder.localDirsHandler;
    }

    public String getUser() {
        return this.user;
    }

    public String getAppId() {
        return this.appId;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getShell() {
        return this.command;
    }

    public LocalDirsHandlerService getLocalDirsHandlerService() {
        return this.localDirsHandler;
    }

    public static final class Builder {
        private String user;
        private String appId;
        private Container container;
        private String command;
        private LocalDirsHandlerService localDirsHandler;

        public Builder setContainer(Container c) {
            this.container = c;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public ContainerExecContext build() {
            return new ContainerExecContext(this);
        }

        public Builder setNMLocalPath(LocalDirsHandlerService ldhs) {
            this.localDirsHandler = ldhs;
            return this;
        }

        public Builder setShell(String command) {
            this.command = command;
            return this;
        }
    }
}

