/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.rcm;

import java.io.IOException;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Grizzly;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.BaseFilter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.FilterChainContext;
import org.apache.hadoop.shaded.org.glassfish.grizzly.filterchain.NextAction;
import org.apache.hadoop.shaded.org.glassfish.grizzly.memory.Buffers;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.apache.hadoop.shaded.org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class ResourceAllocationFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(ResourceAllocationFilter.class);
    protected static final String RESERVE = "reserve";
    protected static final String CEILING = "ceiling";
    protected static final String ALLOCATION_MODE = "org.apache.hadoop.shaded.org.glassfish.grizzly.rcm.policyMethod";
    protected static final String RULE_TOKENS = "org.apache.hadoop.shaded.org.glassfish.grizzly.rcm.policyMetric";
    private static final String DELAY_VALUE = "org.apache.hadoop.shaded.org.glassfish.grizzly.rcm.delay";
    protected static final String QUERY_STRING = "?";
    protected static final String PATH_STRING = "/";
    protected static final ConcurrentHashMap<String, ExecutorService> threadPools = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<String, Double> privilegedTokens = new ConcurrentHashMap();
    protected double leftRatio = 1.0;
    protected String allocationPolicy = "reserve";
    private static final long delayValue = 5000L;
    private final int standardThreadPoolSize;

    public ResourceAllocationFilter() {
        this(5);
    }

    public ResourceAllocationFilter(int standardThreadPoolSize) {
        this.standardThreadPoolSize = standardThreadPoolSize;
        this.init();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        ExecutorService threadPool;
        StringBuilder sb;
        Buffer inputMessage = (Buffer)ctx.getMessage();
        if (!this.parse(inputMessage, 0, sb = new StringBuilder(256))) {
            return ctx.getStopAction(inputMessage);
        }
        String token = this.getContextRoot(sb.toString());
        int delayCount = 0;
        while (this.leftRatio == 0.0 && privilegedTokens.get(token) == null) {
            if (this.allocationPolicy.equals(RESERVE)) {
                this.delay();
                ++delayCount;
            } else if (this.allocationPolicy.equals(CEILING)) {
                if (!this.isThreadPoolInUse()) break;
                this.delay();
                ++delayCount;
            }
            if (delayCount <= 5) continue;
            ctx.getConnection().closeSilently();
            return ctx.getStopAction();
        }
        if ((threadPool = threadPools.get(token)) == null) {
            threadPool = this.filterRequest(token);
            threadPools.put(token, threadPool);
        }
        ctx.nextFilterIdx();
        Runnable runnable = ctx.suspend();
        threadPool.execute(runnable);
        return ctx.getSuspendAction();
    }

    private void delay() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "Delay exception", ex);
        }
    }

    public int getStandardThreadPoolSize() {
        return this.standardThreadPoolSize;
    }

    public ExecutorService filterRequest(String token) {
        ExecutorService es;
        Double threadRatio = privilegedTokens.get(token);
        boolean defaultThreadPool = false;
        if (threadRatio == null) {
            es = threadPools.get("*");
            if (es != null) {
                return es;
            }
            threadRatio = this.leftRatio == 0.0 ? 0.5 : this.leftRatio;
            defaultThreadPool = true;
        }
        int privilegedCount = threadRatio == 1.0 ? this.standardThreadPoolSize : (int)((double)this.standardThreadPoolSize * threadRatio) + 1;
        es = this.newThreadPool(privilegedCount);
        if (defaultThreadPool) {
            threadPools.put("*", es);
        }
        return es;
    }

    protected ExecutorService newThreadPool(int threadCount) {
        if (threadCount == 0) {
            return null;
        }
        ThreadPoolConfig tpc = ThreadPoolConfig.defaultConfig().setPoolName("RCM_" + threadCount).setCorePoolSize(1).setMaxPoolSize(threadCount);
        return GrizzlyExecutorService.createInstance(tpc);
    }

    protected boolean isThreadPoolInUse() {
        Collection<ExecutorService> collection = threadPools.values();
        for (ExecutorService threadPool : collection) {
            ThreadPoolExecutor pool;
            if (!(threadPool instanceof ThreadPoolExecutor) || (pool = (ThreadPoolExecutor)threadPool).getQueue().isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected String getContextRoot(String token) {
        boolean slash;
        int index = token.indexOf(QUERY_STRING);
        if (index != -1) {
            token = token.substring(0, index);
        }
        if (slash = token.endsWith(PATH_STRING)) {
            token = token.substring(0, token.length() - 1);
        }
        return token;
    }

    protected boolean parse(Buffer inputMessage, int state, StringBuilder sb) throws IOException {
        return this.findSpace(inputMessage, state, sb) == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findSpace(Buffer inputMessage, int state, StringBuilder sb) {
        int pos = inputMessage.position();
        int lim = inputMessage.limit();
        try {
            for (int i = pos; i < lim; ++i) {
                char c = (char)inputMessage.get();
                if (c == ' ') {
                    if (++state != 2) continue;
                    int n = state;
                    return n;
                }
                if (state != 1) continue;
                sb.append(c);
            }
            int n = state;
            return n;
        }
        finally {
            Buffers.setPositionLimit(inputMessage, pos, lim);
        }
    }

    private void init() {
        try {
            if (System.getProperty(RULE_TOKENS) != null) {
                StringTokenizer privList = new StringTokenizer(System.getProperty(RULE_TOKENS), ",");
                double countRatio = 0.0;
                while (privList.hasMoreElements()) {
                    StringTokenizer privElement = new StringTokenizer(privList.nextToken());
                    while (privElement.hasMoreElements()) {
                        String tokens = privElement.nextToken();
                        int index = tokens.indexOf("|");
                        double tokenValue = Double.valueOf(tokens.substring(index + 1));
                        privilegedTokens.put(tokens.substring(0, index), tokenValue);
                        countRatio += tokenValue;
                    }
                }
                if (countRatio > 1.0) {
                    logger.info("Thread ratio too high. The total must be lower or equal to 1");
                } else {
                    this.leftRatio = 1.0 - countRatio;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Unable to set the ratio", ex);
        }
        if (System.getProperty(ALLOCATION_MODE) != null) {
            this.allocationPolicy = System.getProperty(ALLOCATION_MODE);
            if (!RESERVE.equals(this.allocationPolicy) && !CEILING.equals(this.allocationPolicy)) {
                logger.info("Invalid allocation policy");
                this.allocationPolicy = RESERVE;
            }
        }
    }
}

