/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.rmadmin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.BatchSaveFederationQueuePoliciesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.BatchSaveFederationQueuePoliciesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationApplicationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationApplicationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationQueuePoliciesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeleteFederationQueuePoliciesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeregisterSubClusterRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.DeregisterSubClusterResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetSubClustersRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.GetSubClustersResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodesToAttributesMappingRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodesToAttributesMappingResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.QueryFederationQueuePoliciesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.QueryFederationQueuePoliciesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.SaveFederationQueuePolicyRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.SaveFederationQueuePolicyResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceResponse;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.rmadmin.RMAdminRequestInterceptor;
import org.apache.hadoop.yarn.server.router.security.authorize.RouterPolicyProvider;
import org.apache.hadoop.yarn.util.LRUCacheHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterRMAdminService
extends AbstractService
implements ResourceManagerAdministrationProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(RouterRMAdminService.class);
    private Server server;
    private InetSocketAddress listenerEndpoint;
    private Map<String, RequestInterceptorChainWrapper> userPipelineMap;

    public RouterRMAdminService() {
        super(RouterRMAdminService.class.getName());
    }

    protected void serviceStart() throws Exception {
        LOG.info("Starting Router RMAdmin Service.");
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.listenerEndpoint = conf.getSocketAddr("yarn.router.bind-host", "yarn.router.rmadmin.address", "0.0.0.0:8052", 8052);
        int maxCacheSize = conf.getInt("yarn.router.pipeline.cache-max-size", 25);
        this.userPipelineMap = Collections.synchronizedMap(new LRUCacheHashMap(maxCacheSize, true));
        Configuration serverConf = new Configuration(conf);
        int numWorkerThreads = serverConf.getInt("yarn.resourcemanager.admin.client.thread-count", 1);
        this.server = rpc.getServer(ResourceManagerAdministrationProtocol.class, (Object)this, this.listenerEndpoint, serverConf, null, numWorkerThreads);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, RouterPolicyProvider.getInstance());
        }
        this.server.start();
        LOG.info("Router RMAdminService listening on address: {}.", (Object)this.server.getListenerAddress());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        LOG.info("Stopping Router RMAdminService.");
        if (this.server != null) {
            this.server.stop();
        }
        this.userPipelineMap.clear();
        super.serviceStop();
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    @VisibleForTesting
    public Server getServer() {
        return this.server;
    }

    @VisibleForTesting
    public RequestInterceptorChainWrapper getInterceptorChain() throws IOException {
        String user = UserGroupInformation.getCurrentUser().getUserName();
        RequestInterceptorChainWrapper chain = this.userPipelineMap.get(user);
        if (chain != null && chain.getRootInterceptor() != null) {
            return chain;
        }
        return this.initializePipeline(user);
    }

    @VisibleForTesting
    protected Map<String, RequestInterceptorChainWrapper> getPipelines() {
        return this.userPipelineMap;
    }

    @VisibleForTesting
    protected RMAdminRequestInterceptor createRequestInterceptorChain() {
        Configuration conf = this.getConfig();
        return RouterServerUtil.createRequestInterceptorChain(conf, "yarn.router.rmadmin.interceptor-class.pipeline", "org.apache.hadoop.yarn.server.router.rmadmin.DefaultRMAdminRequestInterceptor", RMAdminRequestInterceptor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInterceptorChainWrapper initializePipeline(String user) {
        Map<String, RequestInterceptorChainWrapper> map = this.userPipelineMap;
        synchronized (map) {
            if (this.userPipelineMap.containsKey(user)) {
                LOG.info("Request to start an already existing user: {} was received, so ignoring.", (Object)user);
                return this.userPipelineMap.get(user);
            }
            RequestInterceptorChainWrapper chainWrapper = new RequestInterceptorChainWrapper();
            try {
                LOG.info("Initializing request processing pipeline for user: {}.", (Object)user);
                RMAdminRequestInterceptor interceptorChain = this.createRequestInterceptorChain();
                interceptorChain.init(user);
                chainWrapper.init(interceptorChain);
            }
            catch (Exception e) {
                LOG.error("Init RMAdminRequestInterceptor error for user: {}.", (Object)user, (Object)e);
                throw e;
            }
            this.userPipelineMap.put(user, chainWrapper);
            return chainWrapper;
        }
    }

    public String[] getGroupsForUser(String user) throws IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getGroupsForUser(user);
    }

    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws StandbyException, YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().refreshQueues(request);
    }

    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws StandbyException, YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().refreshNodes(request);
    }

    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws StandbyException, YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().refreshSuperUserGroupsConfiguration(request);
    }

    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws StandbyException, YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().refreshUserToGroupsMappings(request);
    }

    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().refreshAdminAcls(request);
    }

    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().refreshServiceAcls(request);
    }

    public UpdateNodeResourceResponse updateNodeResource(UpdateNodeResourceRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().updateNodeResource(request);
    }

    public RefreshNodesResourcesResponse refreshNodesResources(RefreshNodesResourcesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().refreshNodesResources(request);
    }

    public AddToClusterNodeLabelsResponse addToClusterNodeLabels(AddToClusterNodeLabelsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().addToClusterNodeLabels(request);
    }

    public RemoveFromClusterNodeLabelsResponse removeFromClusterNodeLabels(RemoveFromClusterNodeLabelsRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().removeFromClusterNodeLabels(request);
    }

    public ReplaceLabelsOnNodeResponse replaceLabelsOnNode(ReplaceLabelsOnNodeRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().replaceLabelsOnNode(request);
    }

    public CheckForDecommissioningNodesResponse checkForDecommissioningNodes(CheckForDecommissioningNodesRequest checkForDecommissioningNodesRequest) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().checkForDecommissioningNodes(checkForDecommissioningNodesRequest);
    }

    public RefreshClusterMaxPriorityResponse refreshClusterMaxPriority(RefreshClusterMaxPriorityRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().refreshClusterMaxPriority(request);
    }

    public NodesToAttributesMappingResponse mapAttributesToNodes(NodesToAttributesMappingRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().mapAttributesToNodes(request);
    }

    public DeregisterSubClusterResponse deregisterSubCluster(DeregisterSubClusterRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().deregisterSubCluster(request);
    }

    public SaveFederationQueuePolicyResponse saveFederationQueuePolicy(SaveFederationQueuePolicyRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().saveFederationQueuePolicy(request);
    }

    public BatchSaveFederationQueuePoliciesResponse batchSaveFederationQueuePolicies(BatchSaveFederationQueuePoliciesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().batchSaveFederationQueuePolicies(request);
    }

    public QueryFederationQueuePoliciesResponse listFederationQueuePolicies(QueryFederationQueuePoliciesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().listFederationQueuePolicies(request);
    }

    public DeleteFederationApplicationResponse deleteFederationApplication(DeleteFederationApplicationRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().deleteFederationApplication(request);
    }

    public GetSubClustersResponse getFederationSubClusters(GetSubClustersRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().getFederationSubClusters(request);
    }

    public DeleteFederationQueuePoliciesResponse deleteFederationPoliciesByQueues(DeleteFederationQueuePoliciesRequest request) throws YarnException, IOException {
        RequestInterceptorChainWrapper pipeline = this.getInterceptorChain();
        return pipeline.getRootInterceptor().deleteFederationPoliciesByQueues(request);
    }

    @InterfaceAudience.Private
    public static class RequestInterceptorChainWrapper {
        private RMAdminRequestInterceptor rootInterceptor;

        public synchronized void init(RMAdminRequestInterceptor interceptor) {
            this.rootInterceptor = interceptor;
        }

        public synchronized RMAdminRequestInterceptor getRootInterceptor() {
            return this.rootInterceptor;
        }

        protected void finalize() {
            this.rootInterceptor.shutdown();
        }
    }
}

