/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.internal.Quadruple;
import com.microsoft.azure.cosmosdb.rx.internal.BackoffRetryUtility;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;
import rx.functions.Func1;

public class RetryUtils {
    private static final Logger logger = LoggerFactory.getLogger(BackoffRetryUtility.class);

    public static Func1<Observable<? extends Throwable>, Observable<Long>> toRetryWhenFunc(final IRetryPolicy policy) {
        return new Func1<Observable<? extends Throwable>, Observable<Long>>(){

            public Observable<Long> call(Observable<? extends Throwable> throwableObs) {
                return throwableObs.flatMap(t -> {
                    Exception e = (Exception)Utils.as((Object)t, Exception.class);
                    if (e == null) {
                        return Observable.error((Throwable)t);
                    }
                    return policy.shouldRetry(e).toObservable().flatMap(s -> {
                        if (s.backOffTime != null) {
                            return Observable.timer((long)s.backOffTime.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
                        }
                        if (s.exception != null) {
                            return Observable.error((Throwable)s.exception);
                        }
                        return Observable.error((Throwable)t);
                    });
                });
            }
        };
    }

    static <T> Func1<Throwable, Single<T>> toRetryWithAlternateFunc(final Func1<Quadruple<Boolean, Boolean, Duration, Integer>, Single<T>> callbackMethod, final IRetryPolicy policy, final Func1<Quadruple<Boolean, Boolean, Duration, Integer>, Single<T>> inBackoffAlternateCallbackMethod, final Duration minBackoffForInBackoffCallback) {
        return new Func1<Throwable, Single<T>>(){

            public Single<T> call(Throwable t) {
                Exception e = (Exception)Utils.as((Object)t, Exception.class);
                if (e == null) {
                    return Single.error((Throwable)t);
                }
                return policy.shouldRetry(e).flatMap(shouldRetryResult -> {
                    if (!shouldRetryResult.shouldRetry) {
                        if (shouldRetryResult.exception == null) {
                            return Single.error((Throwable)e);
                        }
                        return Single.error((Throwable)shouldRetryResult.exception);
                    }
                    if (inBackoffAlternateCallbackMethod != null && shouldRetryResult.backOffTime.compareTo(minBackoffForInBackoffCallback) > 0) {
                        StopWatch stopwatch = new StopWatch();
                        RetryUtils.startStopWatch(stopwatch);
                        return ((Single)inBackoffAlternateCallbackMethod.call(shouldRetryResult.policyArg)).onErrorResumeNext(RetryUtils.recurrsiveWithAlternateFunc(callbackMethod, policy, inBackoffAlternateCallbackMethod, shouldRetryResult, stopwatch, minBackoffForInBackoffCallback));
                    }
                    return RetryUtils.recurrsiveFunc(callbackMethod, policy, inBackoffAlternateCallbackMethod, shouldRetryResult, minBackoffForInBackoffCallback).delaySubscription(Observable.timer((long)shouldRetryResult.backOffTime.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
                });
            }
        };
    }

    private static <T> Single<T> recurrsiveFunc(Func1<Quadruple<Boolean, Boolean, Duration, Integer>, Single<T>> callbackMethod, IRetryPolicy policy, Func1<Quadruple<Boolean, Boolean, Duration, Integer>, Single<T>> inBackoffAlternateCallbackMethod, IRetryPolicy.ShouldRetryResult shouldRetryResult, Duration minBackoffForInBackoffCallback) {
        return ((Single)callbackMethod.call(shouldRetryResult.policyArg)).onErrorResumeNext(RetryUtils.toRetryWithAlternateFunc(callbackMethod, policy, inBackoffAlternateCallbackMethod, minBackoffForInBackoffCallback));
    }

    private static <T> Func1<Throwable, Single<T>> recurrsiveWithAlternateFunc(final Func1<Quadruple<Boolean, Boolean, Duration, Integer>, Single<T>> callbackMethod, final IRetryPolicy policy, final Func1<Quadruple<Boolean, Boolean, Duration, Integer>, Single<T>> inBackoffAlternateCallbackMethod, final IRetryPolicy.ShouldRetryResult shouldRetryResult, final StopWatch stopwatch, final Duration minBackoffForInBackoffCallback) {
        return new Func1<Throwable, Single<T>>(){

            public Single<T> call(Throwable t) {
                Exception e = (Exception)Utils.as((Object)t, Exception.class);
                if (e == null) {
                    return Single.error((Throwable)t);
                }
                RetryUtils.stopStopWatch(stopwatch);
                logger.info("Failed inBackoffAlternateCallback with {}, proceeding with retry. Time taken: {}ms", (Object)e.toString(), (Object)stopwatch.getTime());
                Duration backoffTime = shouldRetryResult.backOffTime.toMillis() > stopwatch.getTime() ? Duration.ofMillis(shouldRetryResult.backOffTime.toMillis() - stopwatch.getTime()) : Duration.ZERO;
                return RetryUtils.recurrsiveFunc(callbackMethod, policy, inBackoffAlternateCallbackMethod, shouldRetryResult, minBackoffForInBackoffCallback).delaySubscription(Observable.timer((long)backoffTime.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.start();
        }
    }
}

