/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.google.common.collect.ImmutableMap;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ResourceOperation;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdClientChannelInitializer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestManager;
import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Single;

public final class RntbdTransportClient
extends TransportClient
implements AutoCloseable {
    private static final String className = RntbdTransportClient.class.getName();
    private static final AtomicLong counter = new AtomicLong(0L);
    private static final Logger logger = LoggerFactory.getLogger((String)className);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final EndpointFactory endpointFactory;
    private final String name = className + '-' + counter.incrementAndGet();

    RntbdTransportClient(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    RntbdTransportClient(Options options, SslContext sslContext, UserAgentContainer userAgent) {
        this(new EndpointFactory(options, sslContext, userAgent));
    }

    RntbdTransportClient(Configs configs, int requestTimeoutInSeconds, UserAgentContainer userAgent) {
        this(new Options(Duration.ofSeconds(requestTimeoutInSeconds)), configs.getSslContext(), userAgent);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.endpointFactory.close().addListener(future -> {
                if (future.isSuccess()) {
                    logger.info("{} closed", (Object)this);
                    return;
                }
                logger.error("{} close failed: {}", (Object)this, (Object)future.cause());
            });
        } else {
            logger.debug("{} already closed", (Object)this);
        }
    }

    @Override
    public Single<StoreResponse> invokeStoreAsync(URI physicalAddress, ResourceOperation unused, RxDocumentServiceRequest request) {
        Objects.requireNonNull(physicalAddress, "physicalAddress");
        Objects.requireNonNull(request, "request");
        this.throwIfClosed();
        RntbdRequestArgs requestArgs = new RntbdRequestArgs(request, physicalAddress.getPath());
        Endpoint endpoint = this.endpointFactory.getEndpoint(physicalAddress);
        CompletableFuture<StoreResponse> responseFuture = endpoint.write(requestArgs);
        return Single.fromEmitter(emitter -> responseFuture.whenComplete((response, error) -> {
            requestArgs.traceOperation(logger, null, "emitSingle", response, error);
            if (error == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{} [physicalAddress: {}, activityId: {}] Request succeeded with response status: {}", new Object[]{endpoint, physicalAddress, request.getActivityId(), response.getStatus()});
                }
                emitter.onSuccess(response);
            } else {
                if (logger.isErrorEnabled()) {
                    logger.error("{} [physicalAddress: {}, activityId: {}] Request failed: {}", new Object[]{endpoint, physicalAddress, request.getActivityId(), error.getMessage()});
                }
                emitter.onError(error);
            }
            requestArgs.traceOperation(logger, null, "completeEmitSingle", new Object[0]);
        }));
    }

    public String toString() {
        return '[' + this.name + ", endpointCount: " + this.endpointFactory.endpoints.mappingCount() + ']';
    }

    private void throwIfClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException(String.format("%s is closed", this));
        }
    }

    public static final class Options {
        private String certificateHostNameOverride;
        private int maxChannels;
        private int maxRequestsPerChannel;
        private Duration openTimeout = Duration.ZERO;
        private int partitionCount;
        private Duration receiveHangDetectionTime;
        private Duration requestTimeout;
        private Duration sendHangDetectionTime;
        private Duration timerPoolResolution = Duration.ZERO;
        private UserAgentContainer userAgent = null;

        public Options(int requestTimeoutInSeconds) {
            this(Duration.ofSeconds(requestTimeoutInSeconds));
        }

        public Options(Duration requestTimeout) {
            Objects.requireNonNull(requestTimeout);
            if (requestTimeout.compareTo(Duration.ZERO) <= 0) {
                throw new IllegalArgumentException("requestTimeout");
            }
            this.maxChannels = 65535;
            this.maxRequestsPerChannel = 30;
            this.partitionCount = 1;
            this.receiveHangDetectionTime = Duration.ofSeconds(65L);
            this.requestTimeout = requestTimeout;
            this.sendHangDetectionTime = Duration.ofSeconds(10L);
        }

        public String getCertificateHostNameOverride() {
            return this.certificateHostNameOverride;
        }

        public void setCertificateHostNameOverride(String value) {
            this.certificateHostNameOverride = value;
        }

        public int getMaxChannels() {
            return this.maxChannels;
        }

        public void setMaxChannels(int value) {
            this.maxChannels = value;
        }

        public int getMaxRequestsPerChannel() {
            return this.maxRequestsPerChannel;
        }

        public void setMaxRequestsPerChannel(int maxRequestsPerChannel) {
            this.maxRequestsPerChannel = maxRequestsPerChannel;
        }

        public Duration getOpenTimeout() {
            return this.openTimeout.isNegative() || this.openTimeout.isZero() ? this.requestTimeout : this.openTimeout;
        }

        public void setOpenTimeout(Duration value) {
            this.openTimeout = value;
        }

        public int getPartitionCount() {
            return this.partitionCount;
        }

        public void setPartitionCount(int value) {
            this.partitionCount = value;
        }

        public Duration getReceiveHangDetectionTime() {
            return this.receiveHangDetectionTime;
        }

        public void setReceiveHangDetectionTime(Duration value) {
            this.receiveHangDetectionTime = value;
        }

        public Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        public Duration getSendHangDetectionTime() {
            return this.sendHangDetectionTime;
        }

        public void setSendHangDetectionTime(Duration value) {
            this.sendHangDetectionTime = value;
        }

        public Duration getTimerPoolResolution() {
            return Options.calculateTimerPoolResolutionSeconds(this.timerPoolResolution, this.requestTimeout, this.openTimeout);
        }

        public void setTimerPoolResolution(Duration value) {
            this.timerPoolResolution = value;
        }

        public UserAgentContainer getUserAgent() {
            if (this.userAgent != null) {
                return this.userAgent;
            }
            this.userAgent = new UserAgentContainer();
            return this.userAgent;
        }

        public void setUserAgent(UserAgentContainer value) {
            this.userAgent = value;
        }

        private static Duration calculateTimerPoolResolutionSeconds(Duration timerPoolResolution, Duration requestTimeout, Duration openTimeout) {
            Objects.requireNonNull(timerPoolResolution, "timerPoolResolution");
            Objects.requireNonNull(requestTimeout, "requestTimeout");
            Objects.requireNonNull(openTimeout, "openTimeout");
            if (timerPoolResolution.compareTo(Duration.ZERO) <= 0 && requestTimeout.compareTo(Duration.ZERO) <= 0 && openTimeout.compareTo(Duration.ZERO) <= 0) {
                throw new IllegalStateException("RntbdTransportClient.Options");
            }
            if (timerPoolResolution.compareTo(Duration.ZERO) > 0 && timerPoolResolution.compareTo(openTimeout) < 0 && timerPoolResolution.compareTo(requestTimeout) < 0) {
                return timerPoolResolution;
            }
            if (openTimeout.compareTo(Duration.ZERO) > 0 && requestTimeout.compareTo(Duration.ZERO) > 0) {
                return openTimeout.compareTo(requestTimeout) < 0 ? openTimeout : requestTimeout;
            }
            return openTimeout.compareTo(Duration.ZERO) > 0 ? openTimeout : requestTimeout;
        }
    }

    static class EndpointFactory {
        private final ConcurrentHashMap<String, Endpoint> endpoints = new ConcurrentHashMap();
        private final NioEventLoopGroup eventLoopGroup;
        private final Options options;
        private final SslContext sslContext;
        private final UserAgentContainer userAgent;

        EndpointFactory(Options options, SslContext sslContext, UserAgentContainer userAgent) {
            Objects.requireNonNull(options, "options");
            Objects.requireNonNull(sslContext, "sslContext");
            Objects.requireNonNull(userAgent, "userAgent");
            DefaultThreadFactory threadFactory = new DefaultThreadFactory("CosmosEventLoop", true);
            int threadCount = Runtime.getRuntime().availableProcessors();
            this.eventLoopGroup = new NioEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
            this.options = options;
            this.sslContext = sslContext;
            this.userAgent = userAgent;
        }

        int getConnectionTimeout() {
            return (int)this.options.getOpenTimeout().toMillis();
        }

        Options getOptions() {
            return this.options;
        }

        UserAgentContainer getUserAgent() {
            return this.userAgent;
        }

        Future<?> close() {
            return this.eventLoopGroup.shutdownGracefully();
        }

        RntbdClientChannelInitializer createClientChannelInitializer() {
            Object logLevel = logger.isTraceEnabled() ? LogLevel.TRACE : (logger.isDebugEnabled() ? LogLevel.DEBUG : null);
            return new RntbdClientChannelInitializer(this.userAgent, this.sslContext, (LogLevel)logLevel, this.options);
        }

        Endpoint createEndpoint(URI physicalAddress) {
            return new DefaultEndpoint(this, physicalAddress);
        }

        void deleteEndpoint(URI physicalAddress) {
            String authority = physicalAddress.getAuthority();
            Endpoint endpoint = this.endpoints.remove(authority);
            if (endpoint == null) {
                throw new IllegalArgumentException(String.format("physicalAddress: %s", physicalAddress));
            }
            endpoint.close().addListener(future -> {
                if (future.isSuccess()) {
                    logger.info("{} closed channel of communication with {}", (Object)endpoint, (Object)authority);
                    return;
                }
                logger.error("{} failed to close channel of communication with {}: {}", new Object[]{endpoint, authority, future.cause()});
            });
        }

        Endpoint getEndpoint(URI physicalAddress) {
            return this.endpoints.computeIfAbsent(physicalAddress.getAuthority(), authority -> this.createEndpoint(physicalAddress));
        }
    }

    private static class DefaultEndpoint
    implements Endpoint {
        private final ChannelFuture channelFuture;
        private final RntbdRequestManager requestManager;

        DefaultEndpoint(EndpointFactory factory, URI physicalAddress) {
            RntbdClientChannelInitializer clientChannelInitializer = factory.createClientChannelInitializer();
            this.requestManager = clientChannelInitializer.getRequestManager();
            int connectionTimeout = factory.getConnectionTimeout();
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group((EventLoopGroup)factory.eventLoopGroup)).handler((ChannelHandler)clientChannelInitializer)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectionTimeout)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.channelFuture = bootstrap.connect(physicalAddress.getHost(), physicalAddress.getPort());
        }

        @Override
        public Future<?> close() {
            return this.channelFuture.channel().close();
        }

        public String toString() {
            return this.channelFuture.channel().toString();
        }

        @Override
        public CompletableFuture<StoreResponse> write(RntbdRequestArgs requestArgs) {
            Objects.requireNonNull(requestArgs, "requestArgs");
            CompletableFuture<StoreResponse> responseFuture = this.requestManager.createStoreResponseFuture(requestArgs);
            this.channelFuture.addListener(future -> {
                if (future.isSuccess()) {
                    requestArgs.traceOperation(logger, null, "doWrite", new Object[0]);
                    logger.debug("{} connected", (Object)future.channel());
                    DefaultEndpoint.doWrite(future.channel(), requestArgs);
                    return;
                }
                UUID activityId = requestArgs.getActivityId();
                if (future.isCancelled()) {
                    this.requestManager.cancelStoreResponseFuture(activityId);
                    logger.debug("{}{} request cancelled: ", new Object[]{future.channel(), requestArgs, future.cause()});
                } else {
                    Channel channel = future.channel();
                    Throwable cause = future.cause();
                    logger.error("{}{} request failed: ", new Object[]{channel, requestArgs, cause});
                    GoneException goneException = new GoneException(String.format("failed to establish connection to %s: %s", channel.remoteAddress(), cause.getMessage()), cause instanceof Exception ? (Exception)cause : new IOException(cause.getMessage(), cause), (Map)ImmutableMap.of((Object)"x-ms-activity-id", (Object)activityId.toString()), requestArgs.getReplicaPath());
                    logger.debug("{}{} {} mapped to GoneException: ", new Object[]{channel, requestArgs, cause.getClass(), goneException});
                    this.requestManager.completeStoreResponseFutureExceptionally(activityId, goneException);
                }
            });
            return responseFuture;
        }

        private static void doWrite(Channel channel, RntbdRequestArgs requestArgs) {
            channel.write((Object)requestArgs).addListener(future -> {
                requestArgs.traceOperation(logger, null, "writeComplete", future.channel());
                if (future.isSuccess()) {
                    logger.debug("{} request sent: {}", (Object)future.channel(), (Object)requestArgs);
                } else if (future.isCancelled()) {
                    logger.debug("{}{} request cancelled: {}", new Object[]{future.channel(), requestArgs, future.cause().getMessage()});
                } else {
                    Throwable cause = future.cause();
                    logger.error("{}{} request failed due to {}: {}", new Object[]{future.channel(), requestArgs, cause.getClass(), cause.getMessage()});
                }
            });
        }
    }

    static interface Endpoint {
        public Future<?> close();

        public CompletableFuture<StoreResponse> write(RntbdRequestArgs var1);
    }
}

